<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeoFence StructType
 * @subpackage Structs
 */
class GeoFence extends AbstractStructBase
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The ETADate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ETADate;
    /**
     * The NotifyHomeBase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $NotifyHomeBase;
    /**
     * The NotifyDriverByBeep
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $NotifyDriverByBeep;
    /**
     * The NotifyOnce
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $NotifyOnce;
    /**
     * The GeoFenceDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $GeoFenceDirection;
    /**
     * The GeoZonePositive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $GeoZonePositive;
    /**
     * The GeoValidityDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeoValidityDate
     */
    public $GeoValidityDate;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The DriverAlarmText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverAlarmText;
    /**
     * The RestrictedActivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityPlace
     */
    public $RestrictedActivity;
    /**
     * Constructor method for GeoFence
     * @uses GeoFence::setActive()
     * @uses GeoFence::setETADate()
     * @uses GeoFence::setNotifyHomeBase()
     * @uses GeoFence::setNotifyDriverByBeep()
     * @uses GeoFence::setNotifyOnce()
     * @uses GeoFence::setGeoFenceDirection()
     * @uses GeoFence::setGeoZonePositive()
     * @uses GeoFence::setGeoValidityDate()
     * @uses GeoFence::setName()
     * @uses GeoFence::setDriverAlarmText()
     * @uses GeoFence::setRestrictedActivity()
     * @param bool $active
     * @param string $eTADate
     * @param bool $notifyHomeBase
     * @param bool $notifyDriverByBeep
     * @param bool $notifyOnce
     * @param string $geoFenceDirection
     * @param bool $geoZonePositive
     * @param \StructType\GeoValidityDate $geoValidityDate
     * @param string $name
     * @param string $driverAlarmText
     * @param \StructType\ActivityPlace $restrictedActivity
     */
    public function __construct($active = null, $eTADate = null, $notifyHomeBase = null, $notifyDriverByBeep = null, $notifyOnce = null, $geoFenceDirection = null, $geoZonePositive = null, \StructType\GeoValidityDate $geoValidityDate = null, $name = null, $driverAlarmText = null, \StructType\ActivityPlace $restrictedActivity = null)
    {
        $this
            ->setActive($active)
            ->setETADate($eTADate)
            ->setNotifyHomeBase($notifyHomeBase)
            ->setNotifyDriverByBeep($notifyDriverByBeep)
            ->setNotifyOnce($notifyOnce)
            ->setGeoFenceDirection($geoFenceDirection)
            ->setGeoZonePositive($geoZonePositive)
            ->setGeoValidityDate($geoValidityDate)
            ->setName($name)
            ->setDriverAlarmText($driverAlarmText)
            ->setRestrictedActivity($restrictedActivity);
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\GeoFence
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get ETADate value
     * @return string
     */
    public function getETADate()
    {
        return $this->ETADate;
    }
    /**
     * Set ETADate value
     * @param string $eTADate
     * @return \StructType\GeoFence
     */
    public function setETADate($eTADate = null)
    {
        // validation for constraint: string
        if (!is_null($eTADate) && !is_string($eTADate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eTADate)), __LINE__);
        }
        $this->ETADate = $eTADate;
        return $this;
    }
    /**
     * Get NotifyHomeBase value
     * @return bool
     */
    public function getNotifyHomeBase()
    {
        return $this->NotifyHomeBase;
    }
    /**
     * Set NotifyHomeBase value
     * @param bool $notifyHomeBase
     * @return \StructType\GeoFence
     */
    public function setNotifyHomeBase($notifyHomeBase = null)
    {
        // validation for constraint: boolean
        if (!is_null($notifyHomeBase) && !is_bool($notifyHomeBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($notifyHomeBase)), __LINE__);
        }
        $this->NotifyHomeBase = $notifyHomeBase;
        return $this;
    }
    /**
     * Get NotifyDriverByBeep value
     * @return bool
     */
    public function getNotifyDriverByBeep()
    {
        return $this->NotifyDriverByBeep;
    }
    /**
     * Set NotifyDriverByBeep value
     * @param bool $notifyDriverByBeep
     * @return \StructType\GeoFence
     */
    public function setNotifyDriverByBeep($notifyDriverByBeep = null)
    {
        // validation for constraint: boolean
        if (!is_null($notifyDriverByBeep) && !is_bool($notifyDriverByBeep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($notifyDriverByBeep)), __LINE__);
        }
        $this->NotifyDriverByBeep = $notifyDriverByBeep;
        return $this;
    }
    /**
     * Get NotifyOnce value
     * @return bool
     */
    public function getNotifyOnce()
    {
        return $this->NotifyOnce;
    }
    /**
     * Set NotifyOnce value
     * @param bool $notifyOnce
     * @return \StructType\GeoFence
     */
    public function setNotifyOnce($notifyOnce = null)
    {
        // validation for constraint: boolean
        if (!is_null($notifyOnce) && !is_bool($notifyOnce)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($notifyOnce)), __LINE__);
        }
        $this->NotifyOnce = $notifyOnce;
        return $this;
    }
    /**
     * Get GeoFenceDirection value
     * @return string
     */
    public function getGeoFenceDirection()
    {
        return $this->GeoFenceDirection;
    }
    /**
     * Set GeoFenceDirection value
     * @uses \EnumType\EnumGeoFenceDirection::valueIsValid()
     * @uses \EnumType\EnumGeoFenceDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoFenceDirection
     * @return \StructType\GeoFence
     */
    public function setGeoFenceDirection($geoFenceDirection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGeoFenceDirection::valueIsValid($geoFenceDirection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geoFenceDirection, implode(', ', \EnumType\EnumGeoFenceDirection::getValidValues())), __LINE__);
        }
        $this->GeoFenceDirection = $geoFenceDirection;
        return $this;
    }
    /**
     * Get GeoZonePositive value
     * @return bool
     */
    public function getGeoZonePositive()
    {
        return $this->GeoZonePositive;
    }
    /**
     * Set GeoZonePositive value
     * @param bool $geoZonePositive
     * @return \StructType\GeoFence
     */
    public function setGeoZonePositive($geoZonePositive = null)
    {
        // validation for constraint: boolean
        if (!is_null($geoZonePositive) && !is_bool($geoZonePositive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($geoZonePositive)), __LINE__);
        }
        $this->GeoZonePositive = $geoZonePositive;
        return $this;
    }
    /**
     * Get GeoValidityDate value
     * @return \StructType\GeoValidityDate|null
     */
    public function getGeoValidityDate()
    {
        return $this->GeoValidityDate;
    }
    /**
     * Set GeoValidityDate value
     * @param \StructType\GeoValidityDate $geoValidityDate
     * @return \StructType\GeoFence
     */
    public function setGeoValidityDate(\StructType\GeoValidityDate $geoValidityDate = null)
    {
        $this->GeoValidityDate = $geoValidityDate;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\GeoFence
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get DriverAlarmText value
     * @return string|null
     */
    public function getDriverAlarmText()
    {
        return $this->DriverAlarmText;
    }
    /**
     * Set DriverAlarmText value
     * @param string $driverAlarmText
     * @return \StructType\GeoFence
     */
    public function setDriverAlarmText($driverAlarmText = null)
    {
        // validation for constraint: string
        if (!is_null($driverAlarmText) && !is_string($driverAlarmText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverAlarmText)), __LINE__);
        }
        $this->DriverAlarmText = $driverAlarmText;
        return $this;
    }
    /**
     * Get RestrictedActivity value
     * @return \StructType\ActivityPlace|null
     */
    public function getRestrictedActivity()
    {
        return $this->RestrictedActivity;
    }
    /**
     * Set RestrictedActivity value
     * @param \StructType\ActivityPlace $restrictedActivity
     * @return \StructType\GeoFence
     */
    public function setRestrictedActivity(\StructType\ActivityPlace $restrictedActivity = null)
    {
        $this->RestrictedActivity = $restrictedActivity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeoFence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
