<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileInfo StructType
 * @subpackage Structs
 */
class FileInfo extends AbstractStructBase
{
    /**
     * The FileBase64
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileBase64;
    /**
     * The FileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for FileInfo
     * @uses FileInfo::setFileBase64()
     * @uses FileInfo::setFileName()
     * @uses FileInfo::setComment()
     * @param string $fileBase64
     * @param string $fileName
     * @param string $comment
     */
    public function __construct($fileBase64 = null, $fileName = null, $comment = null)
    {
        $this
            ->setFileBase64($fileBase64)
            ->setFileName($fileName)
            ->setComment($comment);
    }
    /**
     * Get FileBase64 value
     * @return string|null
     */
    public function getFileBase64()
    {
        return $this->FileBase64;
    }
    /**
     * Set FileBase64 value
     * @param string $fileBase64
     * @return \StructType\FileInfo
     */
    public function setFileBase64($fileBase64 = null)
    {
        // validation for constraint: string
        if (!is_null($fileBase64) && !is_string($fileBase64)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileBase64)), __LINE__);
        }
        $this->FileBase64 = $fileBase64;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\FileInfo
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\FileInfo
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FileInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
