<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportViaRouteResult StructType
 * @subpackage Structs
 */
class ExportViaRouteResult extends ExecutionResult
{
    /**
     * The Gpx
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Gpx;
    /**
     * Constructor method for ExportViaRouteResult
     * @uses ExportViaRouteResult::setGpx()
     * @param string $gpx
     */
    public function __construct($gpx = null)
    {
        $this
            ->setGpx($gpx);
    }
    /**
     * Get Gpx value
     * @return string|null
     */
    public function getGpx()
    {
        return $this->Gpx;
    }
    /**
     * Set Gpx value
     * @param string $gpx
     * @return \StructType\ExportViaRouteResult
     */
    public function setGpx($gpx = null)
    {
        // validation for constraint: string
        if (!is_null($gpx) && !is_string($gpx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gpx)), __LINE__);
        }
        $this->Gpx = $gpx;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExportViaRouteResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
