<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoScoreSelection StructType
 * @subpackage Structs
 */
class EcoScoreSelection extends AbstractStructBase
{
    /**
     * The EcoScoreScope
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EcoScoreScope;
    /**
     * The Drivers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * The DateTimeRangeSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRangeSelection;
    /**
     * Constructor method for EcoScoreSelection
     * @uses EcoScoreSelection::setEcoScoreScope()
     * @uses EcoScoreSelection::setDrivers()
     * @uses EcoScoreSelection::setDateTimeRangeSelection()
     * @param string $ecoScoreScope
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     */
    public function __construct($ecoScoreScope = null, \ArrayType\ArrayOfIdentifier $drivers = null, \StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this
            ->setEcoScoreScope($ecoScoreScope)
            ->setDrivers($drivers)
            ->setDateTimeRangeSelection($dateTimeRangeSelection);
    }
    /**
     * Get EcoScoreScope value
     * @return string
     */
    public function getEcoScoreScope()
    {
        return $this->EcoScoreScope;
    }
    /**
     * Set EcoScoreScope value
     * @uses \EnumType\EnumEcoScoreScope::valueIsValid()
     * @uses \EnumType\EnumEcoScoreScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ecoScoreScope
     * @return \StructType\EcoScoreSelection
     */
    public function setEcoScoreScope($ecoScoreScope = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumEcoScoreScope::valueIsValid($ecoScoreScope)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ecoScoreScope, implode(', ', \EnumType\EnumEcoScoreScope::getValidValues())), __LINE__);
        }
        $this->EcoScoreScope = $ecoScoreScope;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\EcoScoreSelection
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @return \StructType\EcoScoreSelection
     */
    public function setDateTimeRangeSelection(\StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EcoScoreSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
