<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoPerformanceInfo StructType
 * @subpackage Structs
 */
class EcoPerformanceInfo extends AbstractStructBase
{
    /**
     * The EcoDistance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $EcoDistance;
    /**
     * The EcoDrivingTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EcoDrivingTime;
    /**
     * The AverageAxleWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AverageAxleWeight;
    /**
     * The AltitudeVariations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AltitudeVariations;
    /**
     * Constructor method for EcoPerformanceInfo
     * @uses EcoPerformanceInfo::setEcoDistance()
     * @uses EcoPerformanceInfo::setEcoDrivingTime()
     * @uses EcoPerformanceInfo::setAverageAxleWeight()
     * @uses EcoPerformanceInfo::setAltitudeVariations()
     * @param float $ecoDistance
     * @param int $ecoDrivingTime
     * @param float $averageAxleWeight
     * @param float $altitudeVariations
     */
    public function __construct($ecoDistance = null, $ecoDrivingTime = null, $averageAxleWeight = null, $altitudeVariations = null)
    {
        $this
            ->setEcoDistance($ecoDistance)
            ->setEcoDrivingTime($ecoDrivingTime)
            ->setAverageAxleWeight($averageAxleWeight)
            ->setAltitudeVariations($altitudeVariations);
    }
    /**
     * Get EcoDistance value
     * @return float
     */
    public function getEcoDistance()
    {
        return $this->EcoDistance;
    }
    /**
     * Set EcoDistance value
     * @param float $ecoDistance
     * @return \StructType\EcoPerformanceInfo
     */
    public function setEcoDistance($ecoDistance = null)
    {
        $this->EcoDistance = $ecoDistance;
        return $this;
    }
    /**
     * Get EcoDrivingTime value
     * @return int
     */
    public function getEcoDrivingTime()
    {
        return $this->EcoDrivingTime;
    }
    /**
     * Set EcoDrivingTime value
     * @param int $ecoDrivingTime
     * @return \StructType\EcoPerformanceInfo
     */
    public function setEcoDrivingTime($ecoDrivingTime = null)
    {
        // validation for constraint: int
        if (!is_null($ecoDrivingTime) && !is_numeric($ecoDrivingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ecoDrivingTime)), __LINE__);
        }
        $this->EcoDrivingTime = $ecoDrivingTime;
        return $this;
    }
    /**
     * Get AverageAxleWeight value
     * @return float
     */
    public function getAverageAxleWeight()
    {
        return $this->AverageAxleWeight;
    }
    /**
     * Set AverageAxleWeight value
     * @param float $averageAxleWeight
     * @return \StructType\EcoPerformanceInfo
     */
    public function setAverageAxleWeight($averageAxleWeight = null)
    {
        $this->AverageAxleWeight = $averageAxleWeight;
        return $this;
    }
    /**
     * Get AltitudeVariations value
     * @return float
     */
    public function getAltitudeVariations()
    {
        return $this->AltitudeVariations;
    }
    /**
     * Set AltitudeVariations value
     * @param float $altitudeVariations
     * @return \StructType\EcoPerformanceInfo
     */
    public function setAltitudeVariations($altitudeVariations = null)
    {
        $this->AltitudeVariations = $altitudeVariations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EcoPerformanceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
