<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoPerformanceData StructType
 * @subpackage Structs
 */
class EcoPerformanceData extends AbstractStructBase
{
    /**
     * The AverageCO2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AverageCO2;
    /**
     * The AverageFuelConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AverageFuelConsumption;
    /**
     * The AverageSpeed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AverageSpeed;
    /**
     * The DurationIdling
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationIdling;
    /**
     * The HighRpm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $HighRpm;
    /**
     * The Overspeeding
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Overspeeding;
    /**
     * The Coasting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Coasting;
    /**
     * The PanicBraking
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PanicBraking;
    /**
     * The DurationRetarder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationRetarder;
    /**
     * The DistanceCruiseControl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistanceCruiseControl;
    /**
     * The Stops100Km
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Stops100Km;
    /**
     * The Braking100Km
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Braking100Km;
    /**
     * The GearingInGreenSpot
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $GearingInGreenSpot;
    /**
     * The TopSpeedFluctuations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TopSpeedFluctuations;
    /**
     * The RedRpm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RedRpm;
    /**
     * Constructor method for EcoPerformanceData
     * @uses EcoPerformanceData::setAverageCO2()
     * @uses EcoPerformanceData::setAverageFuelConsumption()
     * @uses EcoPerformanceData::setAverageSpeed()
     * @uses EcoPerformanceData::setDurationIdling()
     * @uses EcoPerformanceData::setHighRpm()
     * @uses EcoPerformanceData::setOverspeeding()
     * @uses EcoPerformanceData::setCoasting()
     * @uses EcoPerformanceData::setPanicBraking()
     * @uses EcoPerformanceData::setDurationRetarder()
     * @uses EcoPerformanceData::setDistanceCruiseControl()
     * @uses EcoPerformanceData::setStops100Km()
     * @uses EcoPerformanceData::setBraking100Km()
     * @uses EcoPerformanceData::setGearingInGreenSpot()
     * @uses EcoPerformanceData::setTopSpeedFluctuations()
     * @uses EcoPerformanceData::setRedRpm()
     * @param float $averageCO2
     * @param float $averageFuelConsumption
     * @param float $averageSpeed
     * @param float $durationIdling
     * @param float $highRpm
     * @param float $overspeeding
     * @param float $coasting
     * @param float $panicBraking
     * @param float $durationRetarder
     * @param float $distanceCruiseControl
     * @param float $stops100Km
     * @param float $braking100Km
     * @param float $gearingInGreenSpot
     * @param float $topSpeedFluctuations
     * @param float $redRpm
     */
    public function __construct($averageCO2 = null, $averageFuelConsumption = null, $averageSpeed = null, $durationIdling = null, $highRpm = null, $overspeeding = null, $coasting = null, $panicBraking = null, $durationRetarder = null, $distanceCruiseControl = null, $stops100Km = null, $braking100Km = null, $gearingInGreenSpot = null, $topSpeedFluctuations = null, $redRpm = null)
    {
        $this
            ->setAverageCO2($averageCO2)
            ->setAverageFuelConsumption($averageFuelConsumption)
            ->setAverageSpeed($averageSpeed)
            ->setDurationIdling($durationIdling)
            ->setHighRpm($highRpm)
            ->setOverspeeding($overspeeding)
            ->setCoasting($coasting)
            ->setPanicBraking($panicBraking)
            ->setDurationRetarder($durationRetarder)
            ->setDistanceCruiseControl($distanceCruiseControl)
            ->setStops100Km($stops100Km)
            ->setBraking100Km($braking100Km)
            ->setGearingInGreenSpot($gearingInGreenSpot)
            ->setTopSpeedFluctuations($topSpeedFluctuations)
            ->setRedRpm($redRpm);
    }
    /**
     * Get AverageCO2 value
     * @return float
     */
    public function getAverageCO2()
    {
        return $this->AverageCO2;
    }
    /**
     * Set AverageCO2 value
     * @param float $averageCO2
     * @return \StructType\EcoPerformanceData
     */
    public function setAverageCO2($averageCO2 = null)
    {
        $this->AverageCO2 = $averageCO2;
        return $this;
    }
    /**
     * Get AverageFuelConsumption value
     * @return float
     */
    public function getAverageFuelConsumption()
    {
        return $this->AverageFuelConsumption;
    }
    /**
     * Set AverageFuelConsumption value
     * @param float $averageFuelConsumption
     * @return \StructType\EcoPerformanceData
     */
    public function setAverageFuelConsumption($averageFuelConsumption = null)
    {
        $this->AverageFuelConsumption = $averageFuelConsumption;
        return $this;
    }
    /**
     * Get AverageSpeed value
     * @return float
     */
    public function getAverageSpeed()
    {
        return $this->AverageSpeed;
    }
    /**
     * Set AverageSpeed value
     * @param float $averageSpeed
     * @return \StructType\EcoPerformanceData
     */
    public function setAverageSpeed($averageSpeed = null)
    {
        $this->AverageSpeed = $averageSpeed;
        return $this;
    }
    /**
     * Get DurationIdling value
     * @return float
     */
    public function getDurationIdling()
    {
        return $this->DurationIdling;
    }
    /**
     * Set DurationIdling value
     * @param float $durationIdling
     * @return \StructType\EcoPerformanceData
     */
    public function setDurationIdling($durationIdling = null)
    {
        $this->DurationIdling = $durationIdling;
        return $this;
    }
    /**
     * Get HighRpm value
     * @return float
     */
    public function getHighRpm()
    {
        return $this->HighRpm;
    }
    /**
     * Set HighRpm value
     * @param float $highRpm
     * @return \StructType\EcoPerformanceData
     */
    public function setHighRpm($highRpm = null)
    {
        $this->HighRpm = $highRpm;
        return $this;
    }
    /**
     * Get Overspeeding value
     * @return float
     */
    public function getOverspeeding()
    {
        return $this->Overspeeding;
    }
    /**
     * Set Overspeeding value
     * @param float $overspeeding
     * @return \StructType\EcoPerformanceData
     */
    public function setOverspeeding($overspeeding = null)
    {
        $this->Overspeeding = $overspeeding;
        return $this;
    }
    /**
     * Get Coasting value
     * @return float
     */
    public function getCoasting()
    {
        return $this->Coasting;
    }
    /**
     * Set Coasting value
     * @param float $coasting
     * @return \StructType\EcoPerformanceData
     */
    public function setCoasting($coasting = null)
    {
        $this->Coasting = $coasting;
        return $this;
    }
    /**
     * Get PanicBraking value
     * @return float
     */
    public function getPanicBraking()
    {
        return $this->PanicBraking;
    }
    /**
     * Set PanicBraking value
     * @param float $panicBraking
     * @return \StructType\EcoPerformanceData
     */
    public function setPanicBraking($panicBraking = null)
    {
        $this->PanicBraking = $panicBraking;
        return $this;
    }
    /**
     * Get DurationRetarder value
     * @return float
     */
    public function getDurationRetarder()
    {
        return $this->DurationRetarder;
    }
    /**
     * Set DurationRetarder value
     * @param float $durationRetarder
     * @return \StructType\EcoPerformanceData
     */
    public function setDurationRetarder($durationRetarder = null)
    {
        $this->DurationRetarder = $durationRetarder;
        return $this;
    }
    /**
     * Get DistanceCruiseControl value
     * @return float
     */
    public function getDistanceCruiseControl()
    {
        return $this->DistanceCruiseControl;
    }
    /**
     * Set DistanceCruiseControl value
     * @param float $distanceCruiseControl
     * @return \StructType\EcoPerformanceData
     */
    public function setDistanceCruiseControl($distanceCruiseControl = null)
    {
        $this->DistanceCruiseControl = $distanceCruiseControl;
        return $this;
    }
    /**
     * Get Stops100Km value
     * @return float
     */
    public function getStops100Km()
    {
        return $this->Stops100Km;
    }
    /**
     * Set Stops100Km value
     * @param float $stops100Km
     * @return \StructType\EcoPerformanceData
     */
    public function setStops100Km($stops100Km = null)
    {
        $this->Stops100Km = $stops100Km;
        return $this;
    }
    /**
     * Get Braking100Km value
     * @return float
     */
    public function getBraking100Km()
    {
        return $this->Braking100Km;
    }
    /**
     * Set Braking100Km value
     * @param float $braking100Km
     * @return \StructType\EcoPerformanceData
     */
    public function setBraking100Km($braking100Km = null)
    {
        $this->Braking100Km = $braking100Km;
        return $this;
    }
    /**
     * Get GearingInGreenSpot value
     * @return float
     */
    public function getGearingInGreenSpot()
    {
        return $this->GearingInGreenSpot;
    }
    /**
     * Set GearingInGreenSpot value
     * @param float $gearingInGreenSpot
     * @return \StructType\EcoPerformanceData
     */
    public function setGearingInGreenSpot($gearingInGreenSpot = null)
    {
        $this->GearingInGreenSpot = $gearingInGreenSpot;
        return $this;
    }
    /**
     * Get TopSpeedFluctuations value
     * @return float
     */
    public function getTopSpeedFluctuations()
    {
        return $this->TopSpeedFluctuations;
    }
    /**
     * Set TopSpeedFluctuations value
     * @param float $topSpeedFluctuations
     * @return \StructType\EcoPerformanceData
     */
    public function setTopSpeedFluctuations($topSpeedFluctuations = null)
    {
        $this->TopSpeedFluctuations = $topSpeedFluctuations;
        return $this;
    }
    /**
     * Get RedRpm value
     * @return float
     */
    public function getRedRpm()
    {
        return $this->RedRpm;
    }
    /**
     * Set RedRpm value
     * @param float $redRpm
     * @return \StructType\EcoPerformanceData
     */
    public function setRedRpm($redRpm = null)
    {
        $this->RedRpm = $redRpm;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EcoPerformanceData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
