<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorPtoResult StructType
 * @subpackage Structs
 */
class EcoMonitorPtoResult extends AbstractStructBase
{
    /**
     * The NumberOfPto
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfPto;
    /**
     * The FuelConsumptionPtoDriving
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FuelConsumptionPtoDriving;
    /**
     * The FuelConsumptionPtoStandStill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FuelConsumptionPtoStandStill;
    /**
     * The DurationPtoDriving
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationPtoDriving;
    /**
     * The DurationPtoStandStill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationPtoStandStill;
    /**
     * Constructor method for EcoMonitorPtoResult
     * @uses EcoMonitorPtoResult::setNumberOfPto()
     * @uses EcoMonitorPtoResult::setFuelConsumptionPtoDriving()
     * @uses EcoMonitorPtoResult::setFuelConsumptionPtoStandStill()
     * @uses EcoMonitorPtoResult::setDurationPtoDriving()
     * @uses EcoMonitorPtoResult::setDurationPtoStandStill()
     * @param int $numberOfPto
     * @param float $fuelConsumptionPtoDriving
     * @param float $fuelConsumptionPtoStandStill
     * @param float $durationPtoDriving
     * @param float $durationPtoStandStill
     */
    public function __construct($numberOfPto = null, $fuelConsumptionPtoDriving = null, $fuelConsumptionPtoStandStill = null, $durationPtoDriving = null, $durationPtoStandStill = null)
    {
        $this
            ->setNumberOfPto($numberOfPto)
            ->setFuelConsumptionPtoDriving($fuelConsumptionPtoDriving)
            ->setFuelConsumptionPtoStandStill($fuelConsumptionPtoStandStill)
            ->setDurationPtoDriving($durationPtoDriving)
            ->setDurationPtoStandStill($durationPtoStandStill);
    }
    /**
     * Get NumberOfPto value
     * @return int
     */
    public function getNumberOfPto()
    {
        return $this->NumberOfPto;
    }
    /**
     * Set NumberOfPto value
     * @param int $numberOfPto
     * @return \StructType\EcoMonitorPtoResult
     */
    public function setNumberOfPto($numberOfPto = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPto) && !is_numeric($numberOfPto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfPto)), __LINE__);
        }
        $this->NumberOfPto = $numberOfPto;
        return $this;
    }
    /**
     * Get FuelConsumptionPtoDriving value
     * @return float
     */
    public function getFuelConsumptionPtoDriving()
    {
        return $this->FuelConsumptionPtoDriving;
    }
    /**
     * Set FuelConsumptionPtoDriving value
     * @param float $fuelConsumptionPtoDriving
     * @return \StructType\EcoMonitorPtoResult
     */
    public function setFuelConsumptionPtoDriving($fuelConsumptionPtoDriving = null)
    {
        $this->FuelConsumptionPtoDriving = $fuelConsumptionPtoDriving;
        return $this;
    }
    /**
     * Get FuelConsumptionPtoStandStill value
     * @return float
     */
    public function getFuelConsumptionPtoStandStill()
    {
        return $this->FuelConsumptionPtoStandStill;
    }
    /**
     * Set FuelConsumptionPtoStandStill value
     * @param float $fuelConsumptionPtoStandStill
     * @return \StructType\EcoMonitorPtoResult
     */
    public function setFuelConsumptionPtoStandStill($fuelConsumptionPtoStandStill = null)
    {
        $this->FuelConsumptionPtoStandStill = $fuelConsumptionPtoStandStill;
        return $this;
    }
    /**
     * Get DurationPtoDriving value
     * @return float
     */
    public function getDurationPtoDriving()
    {
        return $this->DurationPtoDriving;
    }
    /**
     * Set DurationPtoDriving value
     * @param float $durationPtoDriving
     * @return \StructType\EcoMonitorPtoResult
     */
    public function setDurationPtoDriving($durationPtoDriving = null)
    {
        $this->DurationPtoDriving = $durationPtoDriving;
        return $this;
    }
    /**
     * Get DurationPtoStandStill value
     * @return float
     */
    public function getDurationPtoStandStill()
    {
        return $this->DurationPtoStandStill;
    }
    /**
     * Set DurationPtoStandStill value
     * @param float $durationPtoStandStill
     * @return \StructType\EcoMonitorPtoResult
     */
    public function setDurationPtoStandStill($durationPtoStandStill = null)
    {
        $this->DurationPtoStandStill = $durationPtoStandStill;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EcoMonitorPtoResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
