<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorIdlingResult StructType
 * @subpackage Structs
 */
class EcoMonitorIdlingResult extends AbstractStructBase
{
    /**
     * The NumberOfLongIdling
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfLongIdling;
    /**
     * The FuelConsumptionIdling
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FuelConsumptionIdling;
    /**
     * The DurationIdling
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationIdling;
    /**
     * The DurationIdlingPercentage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationIdlingPercentage;
    /**
     * Constructor method for EcoMonitorIdlingResult
     * @uses EcoMonitorIdlingResult::setNumberOfLongIdling()
     * @uses EcoMonitorIdlingResult::setFuelConsumptionIdling()
     * @uses EcoMonitorIdlingResult::setDurationIdling()
     * @uses EcoMonitorIdlingResult::setDurationIdlingPercentage()
     * @param int $numberOfLongIdling
     * @param float $fuelConsumptionIdling
     * @param float $durationIdling
     * @param float $durationIdlingPercentage
     */
    public function __construct($numberOfLongIdling = null, $fuelConsumptionIdling = null, $durationIdling = null, $durationIdlingPercentage = null)
    {
        $this
            ->setNumberOfLongIdling($numberOfLongIdling)
            ->setFuelConsumptionIdling($fuelConsumptionIdling)
            ->setDurationIdling($durationIdling)
            ->setDurationIdlingPercentage($durationIdlingPercentage);
    }
    /**
     * Get NumberOfLongIdling value
     * @return int
     */
    public function getNumberOfLongIdling()
    {
        return $this->NumberOfLongIdling;
    }
    /**
     * Set NumberOfLongIdling value
     * @param int $numberOfLongIdling
     * @return \StructType\EcoMonitorIdlingResult
     */
    public function setNumberOfLongIdling($numberOfLongIdling = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfLongIdling) && !is_numeric($numberOfLongIdling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfLongIdling)), __LINE__);
        }
        $this->NumberOfLongIdling = $numberOfLongIdling;
        return $this;
    }
    /**
     * Get FuelConsumptionIdling value
     * @return float
     */
    public function getFuelConsumptionIdling()
    {
        return $this->FuelConsumptionIdling;
    }
    /**
     * Set FuelConsumptionIdling value
     * @param float $fuelConsumptionIdling
     * @return \StructType\EcoMonitorIdlingResult
     */
    public function setFuelConsumptionIdling($fuelConsumptionIdling = null)
    {
        $this->FuelConsumptionIdling = $fuelConsumptionIdling;
        return $this;
    }
    /**
     * Get DurationIdling value
     * @return float
     */
    public function getDurationIdling()
    {
        return $this->DurationIdling;
    }
    /**
     * Set DurationIdling value
     * @param float $durationIdling
     * @return \StructType\EcoMonitorIdlingResult
     */
    public function setDurationIdling($durationIdling = null)
    {
        $this->DurationIdling = $durationIdling;
        return $this;
    }
    /**
     * Get DurationIdlingPercentage value
     * @return float
     */
    public function getDurationIdlingPercentage()
    {
        return $this->DurationIdlingPercentage;
    }
    /**
     * Set DurationIdlingPercentage value
     * @param float $durationIdlingPercentage
     * @return \StructType\EcoMonitorIdlingResult
     */
    public function setDurationIdlingPercentage($durationIdlingPercentage = null)
    {
        $this->DurationIdlingPercentage = $durationIdlingPercentage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EcoMonitorIdlingResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
