<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorAnticipationResult StructType
 * @subpackage Structs
 */
class EcoMonitorAnticipationResult extends AbstractStructBase
{
    /**
     * The NumberOfStops
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfStops;
    /**
     * The NumberOfBrakes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfBrakes;
    /**
     * The NumberOfPanicBrakes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfPanicBrakes;
    /**
     * The DistanceByBrakes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistanceByBrakes;
    /**
     * The DurationByBrakes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationByBrakes;
    /**
     * The DurationByRetarder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationByRetarder;
    /**
     * The DurationHighRPMnoFuel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationHighRPMnoFuel;
    /**
     * Constructor method for EcoMonitorAnticipationResult
     * @uses EcoMonitorAnticipationResult::setNumberOfStops()
     * @uses EcoMonitorAnticipationResult::setNumberOfBrakes()
     * @uses EcoMonitorAnticipationResult::setNumberOfPanicBrakes()
     * @uses EcoMonitorAnticipationResult::setDistanceByBrakes()
     * @uses EcoMonitorAnticipationResult::setDurationByBrakes()
     * @uses EcoMonitorAnticipationResult::setDurationByRetarder()
     * @uses EcoMonitorAnticipationResult::setDurationHighRPMnoFuel()
     * @param int $numberOfStops
     * @param int $numberOfBrakes
     * @param int $numberOfPanicBrakes
     * @param float $distanceByBrakes
     * @param float $durationByBrakes
     * @param float $durationByRetarder
     * @param float $durationHighRPMnoFuel
     */
    public function __construct($numberOfStops = null, $numberOfBrakes = null, $numberOfPanicBrakes = null, $distanceByBrakes = null, $durationByBrakes = null, $durationByRetarder = null, $durationHighRPMnoFuel = null)
    {
        $this
            ->setNumberOfStops($numberOfStops)
            ->setNumberOfBrakes($numberOfBrakes)
            ->setNumberOfPanicBrakes($numberOfPanicBrakes)
            ->setDistanceByBrakes($distanceByBrakes)
            ->setDurationByBrakes($durationByBrakes)
            ->setDurationByRetarder($durationByRetarder)
            ->setDurationHighRPMnoFuel($durationHighRPMnoFuel);
    }
    /**
     * Get NumberOfStops value
     * @return int
     */
    public function getNumberOfStops()
    {
        return $this->NumberOfStops;
    }
    /**
     * Set NumberOfStops value
     * @param int $numberOfStops
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public function setNumberOfStops($numberOfStops = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfStops) && !is_numeric($numberOfStops)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfStops)), __LINE__);
        }
        $this->NumberOfStops = $numberOfStops;
        return $this;
    }
    /**
     * Get NumberOfBrakes value
     * @return int
     */
    public function getNumberOfBrakes()
    {
        return $this->NumberOfBrakes;
    }
    /**
     * Set NumberOfBrakes value
     * @param int $numberOfBrakes
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public function setNumberOfBrakes($numberOfBrakes = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBrakes) && !is_numeric($numberOfBrakes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfBrakes)), __LINE__);
        }
        $this->NumberOfBrakes = $numberOfBrakes;
        return $this;
    }
    /**
     * Get NumberOfPanicBrakes value
     * @return int
     */
    public function getNumberOfPanicBrakes()
    {
        return $this->NumberOfPanicBrakes;
    }
    /**
     * Set NumberOfPanicBrakes value
     * @param int $numberOfPanicBrakes
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public function setNumberOfPanicBrakes($numberOfPanicBrakes = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPanicBrakes) && !is_numeric($numberOfPanicBrakes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfPanicBrakes)), __LINE__);
        }
        $this->NumberOfPanicBrakes = $numberOfPanicBrakes;
        return $this;
    }
    /**
     * Get DistanceByBrakes value
     * @return float
     */
    public function getDistanceByBrakes()
    {
        return $this->DistanceByBrakes;
    }
    /**
     * Set DistanceByBrakes value
     * @param float $distanceByBrakes
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public function setDistanceByBrakes($distanceByBrakes = null)
    {
        $this->DistanceByBrakes = $distanceByBrakes;
        return $this;
    }
    /**
     * Get DurationByBrakes value
     * @return float
     */
    public function getDurationByBrakes()
    {
        return $this->DurationByBrakes;
    }
    /**
     * Set DurationByBrakes value
     * @param float $durationByBrakes
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public function setDurationByBrakes($durationByBrakes = null)
    {
        $this->DurationByBrakes = $durationByBrakes;
        return $this;
    }
    /**
     * Get DurationByRetarder value
     * @return float
     */
    public function getDurationByRetarder()
    {
        return $this->DurationByRetarder;
    }
    /**
     * Set DurationByRetarder value
     * @param float $durationByRetarder
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public function setDurationByRetarder($durationByRetarder = null)
    {
        $this->DurationByRetarder = $durationByRetarder;
        return $this;
    }
    /**
     * Get DurationHighRPMnoFuel value
     * @return float
     */
    public function getDurationHighRPMnoFuel()
    {
        return $this->DurationHighRPMnoFuel;
    }
    /**
     * Set DurationHighRPMnoFuel value
     * @param float $durationHighRPMnoFuel
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public function setDurationHighRPMnoFuel($durationHighRPMnoFuel = null)
    {
        $this->DurationHighRPMnoFuel = $durationHighRPMnoFuel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EcoMonitorAnticipationResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
