<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoAssistantWeekItem StructType
 * @subpackage Structs
 */
class EcoAssistantWeekItem extends EcoAssistantItem
{
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Distance;
    /**
     * The EcoAssistantDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEcoAssistantDayItem
     */
    public $EcoAssistantDays;
    /**
     * Constructor method for EcoAssistantWeekItem
     * @uses EcoAssistantWeekItem::setDistance()
     * @uses EcoAssistantWeekItem::setEcoAssistantDays()
     * @param int $distance
     * @param \ArrayType\ArrayOfEcoAssistantDayItem $ecoAssistantDays
     */
    public function __construct($distance = null, \ArrayType\ArrayOfEcoAssistantDayItem $ecoAssistantDays = null)
    {
        $this
            ->setDistance($distance)
            ->setEcoAssistantDays($ecoAssistantDays);
    }
    /**
     * Get Distance value
     * @return int
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\EcoAssistantWeekItem
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !is_numeric($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get EcoAssistantDays value
     * @return \ArrayType\ArrayOfEcoAssistantDayItem|null
     */
    public function getEcoAssistantDays()
    {
        return $this->EcoAssistantDays;
    }
    /**
     * Set EcoAssistantDays value
     * @param \ArrayType\ArrayOfEcoAssistantDayItem $ecoAssistantDays
     * @return \StructType\EcoAssistantWeekItem
     */
    public function setEcoAssistantDays(\ArrayType\ArrayOfEcoAssistantDayItem $ecoAssistantDays = null)
    {
        $this->EcoAssistantDays = $ecoAssistantDays;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EcoAssistantWeekItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
