<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DriverSubGroupItem StructType
 * @subpackage Structs
 */
class DriverSubGroupItem extends AbstractStructBase
{
    /**
     * The SubGroupCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupCode;
    /**
     * The SubGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupName;
    /**
     * The DriverList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTrackedDriver
     */
    public $DriverList;
    /**
     * Constructor method for DriverSubGroupItem
     * @uses DriverSubGroupItem::setSubGroupCode()
     * @uses DriverSubGroupItem::setSubGroupName()
     * @uses DriverSubGroupItem::setDriverList()
     * @param string $subGroupCode
     * @param string $subGroupName
     * @param \ArrayType\ArrayOfTrackedDriver $driverList
     */
    public function __construct($subGroupCode = null, $subGroupName = null, \ArrayType\ArrayOfTrackedDriver $driverList = null)
    {
        $this
            ->setSubGroupCode($subGroupCode)
            ->setSubGroupName($subGroupName)
            ->setDriverList($driverList);
    }
    /**
     * Get SubGroupCode value
     * @return string|null
     */
    public function getSubGroupCode()
    {
        return $this->SubGroupCode;
    }
    /**
     * Set SubGroupCode value
     * @param string $subGroupCode
     * @return \StructType\DriverSubGroupItem
     */
    public function setSubGroupCode($subGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupCode) && !is_string($subGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subGroupCode)), __LINE__);
        }
        $this->SubGroupCode = $subGroupCode;
        return $this;
    }
    /**
     * Get SubGroupName value
     * @return string|null
     */
    public function getSubGroupName()
    {
        return $this->SubGroupName;
    }
    /**
     * Set SubGroupName value
     * @param string $subGroupName
     * @return \StructType\DriverSubGroupItem
     */
    public function setSubGroupName($subGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupName) && !is_string($subGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subGroupName)), __LINE__);
        }
        $this->SubGroupName = $subGroupName;
        return $this;
    }
    /**
     * Get DriverList value
     * @return \ArrayType\ArrayOfTrackedDriver|null
     */
    public function getDriverList()
    {
        return $this->DriverList;
    }
    /**
     * Set DriverList value
     * @param \ArrayType\ArrayOfTrackedDriver $driverList
     * @return \StructType\DriverSubGroupItem
     */
    public function setDriverList(\ArrayType\ArrayOfTrackedDriver $driverList = null)
    {
        $this->DriverList = $driverList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DriverSubGroupItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
