<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document_V6 StructType
 * @subpackage Structs
 */
class Document_V6 extends AbstractStructBase
{
    /**
     * The ScanId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ScanId;
    /**
     * The CreationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The LastFileRecieveDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastFileRecieveDate;
    /**
     * The ScannedPages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ScannedPages;
    /**
     * The ScanDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ScanDate;
    /**
     * The Job
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JobIdentifier_V2
     */
    public $Job;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProductIdentifier_V2
     */
    public $Product;
    /**
     * The SerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerialNumber;
    /**
     * The FileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The Place
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlaceIdentifier_V4
     */
    public $Place;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The Trip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TripIdentifier_V2
     */
    public $Trip;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The TypeDoc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeDoc;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Document_V6
     * @uses Document_V6::setScanId()
     * @uses Document_V6::setCreationDate()
     * @uses Document_V6::setLastFileRecieveDate()
     * @uses Document_V6::setScannedPages()
     * @uses Document_V6::setScanDate()
     * @uses Document_V6::setJob()
     * @uses Document_V6::setProduct()
     * @uses Document_V6::setSerialNumber()
     * @uses Document_V6::setFileName()
     * @uses Document_V6::setPlace()
     * @uses Document_V6::setVehicle()
     * @uses Document_V6::setDriver()
     * @uses Document_V6::setTrip()
     * @uses Document_V6::setPosition()
     * @uses Document_V6::setTypeDoc()
     * @uses Document_V6::setActivity()
     * @uses Document_V6::setComment()
     * @param int $scanId
     * @param string $creationDate
     * @param string $lastFileRecieveDate
     * @param int $scannedPages
     * @param string $scanDate
     * @param \StructType\JobIdentifier_V2 $job
     * @param \StructType\ProductIdentifier_V2 $product
     * @param string $serialNumber
     * @param string $fileName
     * @param \StructType\PlaceIdentifier_V4 $place
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\TripIdentifier_V2 $trip
     * @param \StructType\PositionResult $position
     * @param string $typeDoc
     * @param \StructType\Activity $activity
     * @param string $comment
     */
    public function __construct($scanId = null, $creationDate = null, $lastFileRecieveDate = null, $scannedPages = null, $scanDate = null, \StructType\JobIdentifier_V2 $job = null, \StructType\ProductIdentifier_V2 $product = null, $serialNumber = null, $fileName = null, \StructType\PlaceIdentifier_V4 $place = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\TripIdentifier_V2 $trip = null, \StructType\PositionResult $position = null, $typeDoc = null, \StructType\Activity $activity = null, $comment = null)
    {
        $this
            ->setScanId($scanId)
            ->setCreationDate($creationDate)
            ->setLastFileRecieveDate($lastFileRecieveDate)
            ->setScannedPages($scannedPages)
            ->setScanDate($scanDate)
            ->setJob($job)
            ->setProduct($product)
            ->setSerialNumber($serialNumber)
            ->setFileName($fileName)
            ->setPlace($place)
            ->setVehicle($vehicle)
            ->setDriver($driver)
            ->setTrip($trip)
            ->setPosition($position)
            ->setTypeDoc($typeDoc)
            ->setActivity($activity)
            ->setComment($comment);
    }
    /**
     * Get ScanId value
     * @return int
     */
    public function getScanId()
    {
        return $this->ScanId;
    }
    /**
     * Set ScanId value
     * @param int $scanId
     * @return \StructType\Document_V6
     */
    public function setScanId($scanId = null)
    {
        // validation for constraint: int
        if (!is_null($scanId) && !is_numeric($scanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($scanId)), __LINE__);
        }
        $this->ScanId = $scanId;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\Document_V6
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get LastFileRecieveDate value
     * @return string
     */
    public function getLastFileRecieveDate()
    {
        return $this->LastFileRecieveDate;
    }
    /**
     * Set LastFileRecieveDate value
     * @param string $lastFileRecieveDate
     * @return \StructType\Document_V6
     */
    public function setLastFileRecieveDate($lastFileRecieveDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastFileRecieveDate) && !is_string($lastFileRecieveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastFileRecieveDate)), __LINE__);
        }
        $this->LastFileRecieveDate = $lastFileRecieveDate;
        return $this;
    }
    /**
     * Get ScannedPages value
     * @return int
     */
    public function getScannedPages()
    {
        return $this->ScannedPages;
    }
    /**
     * Set ScannedPages value
     * @param int $scannedPages
     * @return \StructType\Document_V6
     */
    public function setScannedPages($scannedPages = null)
    {
        // validation for constraint: int
        if (!is_null($scannedPages) && !is_numeric($scannedPages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($scannedPages)), __LINE__);
        }
        $this->ScannedPages = $scannedPages;
        return $this;
    }
    /**
     * Get ScanDate value
     * @return string
     */
    public function getScanDate()
    {
        return $this->ScanDate;
    }
    /**
     * Set ScanDate value
     * @param string $scanDate
     * @return \StructType\Document_V6
     */
    public function setScanDate($scanDate = null)
    {
        // validation for constraint: string
        if (!is_null($scanDate) && !is_string($scanDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scanDate)), __LINE__);
        }
        $this->ScanDate = $scanDate;
        return $this;
    }
    /**
     * Get Job value
     * @return \StructType\JobIdentifier_V2|null
     */
    public function getJob()
    {
        return $this->Job;
    }
    /**
     * Set Job value
     * @param \StructType\JobIdentifier_V2 $job
     * @return \StructType\Document_V6
     */
    public function setJob(\StructType\JobIdentifier_V2 $job = null)
    {
        $this->Job = $job;
        return $this;
    }
    /**
     * Get Product value
     * @return \StructType\ProductIdentifier_V2|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \StructType\ProductIdentifier_V2 $product
     * @return \StructType\Document_V6
     */
    public function setProduct(\StructType\ProductIdentifier_V2 $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \StructType\Document_V6
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\Document_V6
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlaceIdentifier_V4|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlaceIdentifier_V4 $place
     * @return \StructType\Document_V6
     */
    public function setPlace(\StructType\PlaceIdentifier_V4 $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\Document_V6
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\Document_V6
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\TripIdentifier_V2|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\TripIdentifier_V2 $trip
     * @return \StructType\Document_V6
     */
    public function setTrip(\StructType\TripIdentifier_V2 $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\Document_V6
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get TypeDoc value
     * @return string|null
     */
    public function getTypeDoc()
    {
        return $this->TypeDoc;
    }
    /**
     * Set TypeDoc value
     * @param string $typeDoc
     * @return \StructType\Document_V6
     */
    public function setTypeDoc($typeDoc = null)
    {
        // validation for constraint: string
        if (!is_null($typeDoc) && !is_string($typeDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeDoc)), __LINE__);
        }
        $this->TypeDoc = $typeDoc;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\Document_V6
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Document_V6
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Document_V6
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
