<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistanceReportSelection StructType
 * @subpackage Structs
 */
class DistanceReportSelection extends AbstractStructBase
{
    /**
     * The SummeryLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SummeryLevel;
    /**
     * The KmMargin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $KmMargin;
    /**
     * The Vehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * The Drivers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * The DateTimeRangeSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRangeSelection;
    /**
     * The DateTimeSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeSelection
     */
    public $DateTimeSelection;
    /**
     * Constructor method for DistanceReportSelection
     * @uses DistanceReportSelection::setSummeryLevel()
     * @uses DistanceReportSelection::setKmMargin()
     * @uses DistanceReportSelection::setVehicles()
     * @uses DistanceReportSelection::setDrivers()
     * @uses DistanceReportSelection::setDateTimeRangeSelection()
     * @uses DistanceReportSelection::setDateTimeSelection()
     * @param string $summeryLevel
     * @param int $kmMargin
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @param \StructType\DateTimeSelection $dateTimeSelection
     */
    public function __construct($summeryLevel = null, $kmMargin = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null, \ArrayType\ArrayOfIdentifier $drivers = null, \StructType\DateTimeRangeSelection $dateTimeRangeSelection = null, \StructType\DateTimeSelection $dateTimeSelection = null)
    {
        $this
            ->setSummeryLevel($summeryLevel)
            ->setKmMargin($kmMargin)
            ->setVehicles($vehicles)
            ->setDrivers($drivers)
            ->setDateTimeRangeSelection($dateTimeRangeSelection)
            ->setDateTimeSelection($dateTimeSelection);
    }
    /**
     * Get SummeryLevel value
     * @return string
     */
    public function getSummeryLevel()
    {
        return $this->SummeryLevel;
    }
    /**
     * Set SummeryLevel value
     * @uses \EnumType\SummaryLevel::valueIsValid()
     * @uses \EnumType\SummaryLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $summeryLevel
     * @return \StructType\DistanceReportSelection
     */
    public function setSummeryLevel($summeryLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SummaryLevel::valueIsValid($summeryLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $summeryLevel, implode(', ', \EnumType\SummaryLevel::getValidValues())), __LINE__);
        }
        $this->SummeryLevel = $summeryLevel;
        return $this;
    }
    /**
     * Get KmMargin value
     * @return int
     */
    public function getKmMargin()
    {
        return $this->KmMargin;
    }
    /**
     * Set KmMargin value
     * @param int $kmMargin
     * @return \StructType\DistanceReportSelection
     */
    public function setKmMargin($kmMargin = null)
    {
        // validation for constraint: int
        if (!is_null($kmMargin) && !is_numeric($kmMargin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmMargin)), __LINE__);
        }
        $this->KmMargin = $kmMargin;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\DistanceReportSelection
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\DistanceReportSelection
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @return \StructType\DistanceReportSelection
     */
    public function setDateTimeRangeSelection(\StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
    /**
     * Get DateTimeSelection value
     * @return \StructType\DateTimeSelection|null
     */
    public function getDateTimeSelection()
    {
        return $this->DateTimeSelection;
    }
    /**
     * Set DateTimeSelection value
     * @param \StructType\DateTimeSelection $dateTimeSelection
     * @return \StructType\DistanceReportSelection
     */
    public function setDateTimeSelection(\StructType\DateTimeSelection $dateTimeSelection = null)
    {
        $this->DateTimeSelection = $dateTimeSelection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DistanceReportSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
