<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiagnosticSearchItem StructType
 * @subpackage Structs
 */
class DiagnosticSearchItem extends AbstractStructBase
{
    /**
     * The DiagnosticType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DiagnosticType;
    /**
     * The DiagnosticIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiagnosticIdentifier;
    /**
     * Constructor method for DiagnosticSearchItem
     * @uses DiagnosticSearchItem::setDiagnosticType()
     * @uses DiagnosticSearchItem::setDiagnosticIdentifier()
     * @param string $diagnosticType
     * @param string $diagnosticIdentifier
     */
    public function __construct($diagnosticType = null, $diagnosticIdentifier = null)
    {
        $this
            ->setDiagnosticType($diagnosticType)
            ->setDiagnosticIdentifier($diagnosticIdentifier);
    }
    /**
     * Get DiagnosticType value
     * @return string
     */
    public function getDiagnosticType()
    {
        return $this->DiagnosticType;
    }
    /**
     * Set DiagnosticType value
     * @uses \EnumType\EnumDiagnosticType::valueIsValid()
     * @uses \EnumType\EnumDiagnosticType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $diagnosticType
     * @return \StructType\DiagnosticSearchItem
     */
    public function setDiagnosticType($diagnosticType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumDiagnosticType::valueIsValid($diagnosticType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $diagnosticType, implode(', ', \EnumType\EnumDiagnosticType::getValidValues())), __LINE__);
        }
        $this->DiagnosticType = $diagnosticType;
        return $this;
    }
    /**
     * Get DiagnosticIdentifier value
     * @return string|null
     */
    public function getDiagnosticIdentifier()
    {
        return $this->DiagnosticIdentifier;
    }
    /**
     * Set DiagnosticIdentifier value
     * @param string $diagnosticIdentifier
     * @return \StructType\DiagnosticSearchItem
     */
    public function setDiagnosticIdentifier($diagnosticIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($diagnosticIdentifier) && !is_string($diagnosticIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($diagnosticIdentifier)), __LINE__);
        }
        $this->DiagnosticIdentifier = $diagnosticIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DiagnosticSearchItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
