<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateTimeAndIdSelection StructType
 * @subpackage Structs
 */
class DateTimeAndIdSelection extends AbstractStructBase
{
    /**
     * The DateTimeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTimeType;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Value;
    /**
     * Constructor method for DateTimeAndIdSelection
     * @uses DateTimeAndIdSelection::setDateTimeType()
     * @uses DateTimeAndIdSelection::setValue()
     * @param string $dateTimeType
     * @param int $value
     */
    public function __construct($dateTimeType = null, $value = null)
    {
        $this
            ->setDateTimeType($dateTimeType)
            ->setValue($value);
    }
    /**
     * Get DateTimeType value
     * @return string
     */
    public function getDateTimeType()
    {
        return $this->DateTimeType;
    }
    /**
     * Set DateTimeType value
     * @uses \EnumType\EnumSelectionDateTimeAndIdType::valueIsValid()
     * @uses \EnumType\EnumSelectionDateTimeAndIdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateTimeType
     * @return \StructType\DateTimeAndIdSelection
     */
    public function setDateTimeType($dateTimeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSelectionDateTimeAndIdType::valueIsValid($dateTimeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dateTimeType, implode(', ', \EnumType\EnumSelectionDateTimeAndIdType::getValidValues())), __LINE__);
        }
        $this->DateTimeType = $dateTimeType;
        return $this;
    }
    /**
     * Get Value value
     * @return int
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param int $value
     * @return \StructType\DateTimeAndIdSelection
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !is_numeric($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DateTimeAndIdSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
