<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataType StructType
 * @subpackage Structs
 */
class DataType extends CodeInfo
{
    /**
     * The Length
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Length;
    /**
     * The Decimals
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Decimals;
    /**
     * The Digits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Digits;
    /**
     * Constructor method for DataType
     * @uses DataType::setLength()
     * @uses DataType::setDecimals()
     * @uses DataType::setDigits()
     * @param int $length
     * @param int $decimals
     * @param int $digits
     */
    public function __construct($length = null, $decimals = null, $digits = null)
    {
        $this
            ->setLength($length)
            ->setDecimals($decimals)
            ->setDigits($digits);
    }
    /**
     * Get Length value
     * @return int
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param int $length
     * @return \StructType\DataType
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !is_numeric($length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Decimals value
     * @return int
     */
    public function getDecimals()
    {
        return $this->Decimals;
    }
    /**
     * Set Decimals value
     * @param int $decimals
     * @return \StructType\DataType
     */
    public function setDecimals($decimals = null)
    {
        // validation for constraint: int
        if (!is_null($decimals) && !is_numeric($decimals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decimals)), __LINE__);
        }
        $this->Decimals = $decimals;
        return $this;
    }
    /**
     * Get Digits value
     * @return int
     */
    public function getDigits()
    {
        return $this->Digits;
    }
    /**
     * Set Digits value
     * @param int $digits
     * @return \StructType\DataType
     */
    public function setDigits($digits = null)
    {
        // validation for constraint: int
        if (!is_null($digits) && !is_numeric($digits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($digits)), __LINE__);
        }
        $this->Digits = $digits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
