<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Consultation_V3 StructType
 * @subpackage Structs
 */
class Consultation_V3 extends AbstractStructBase
{
    /**
     * The ArrivalDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ArrivalDate;
    /**
     * The LeavingDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LeavingDate;
    /**
     * The ModificationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The Km
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Km;
    /**
     * The ConsultationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ConsultationID;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Place
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlaceIdentifier
     */
    public $Place;
    /**
     * The Trip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TripIdentifier
     */
    public $Trip;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The CoDriver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $CoDriver;
    /**
     * Constructor method for Consultation_V3
     * @uses Consultation_V3::setArrivalDate()
     * @uses Consultation_V3::setLeavingDate()
     * @uses Consultation_V3::setModificationDate()
     * @uses Consultation_V3::setKm()
     * @uses Consultation_V3::setConsultationID()
     * @uses Consultation_V3::setActivity()
     * @uses Consultation_V3::setPlace()
     * @uses Consultation_V3::setTrip()
     * @uses Consultation_V3::setVehicle()
     * @uses Consultation_V3::setDriver()
     * @uses Consultation_V3::setPosition()
     * @uses Consultation_V3::setCoDriver()
     * @param string $arrivalDate
     * @param string $leavingDate
     * @param string $modificationDate
     * @param int $km
     * @param int $consultationID
     * @param \StructType\Activity $activity
     * @param \StructType\PlaceIdentifier $place
     * @param \StructType\TripIdentifier $trip
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\Position $position
     * @param \StructType\IdentifierPerson_V2 $coDriver
     */
    public function __construct($arrivalDate = null, $leavingDate = null, $modificationDate = null, $km = null, $consultationID = null, \StructType\Activity $activity = null, \StructType\PlaceIdentifier $place = null, \StructType\TripIdentifier $trip = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\Position $position = null, \StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this
            ->setArrivalDate($arrivalDate)
            ->setLeavingDate($leavingDate)
            ->setModificationDate($modificationDate)
            ->setKm($km)
            ->setConsultationID($consultationID)
            ->setActivity($activity)
            ->setPlace($place)
            ->setTrip($trip)
            ->setVehicle($vehicle)
            ->setDriver($driver)
            ->setPosition($position)
            ->setCoDriver($coDriver);
    }
    /**
     * Get ArrivalDate value
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\Consultation_V3
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get LeavingDate value
     * @return string
     */
    public function getLeavingDate()
    {
        return $this->LeavingDate;
    }
    /**
     * Set LeavingDate value
     * @param string $leavingDate
     * @return \StructType\Consultation_V3
     */
    public function setLeavingDate($leavingDate = null)
    {
        // validation for constraint: string
        if (!is_null($leavingDate) && !is_string($leavingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leavingDate)), __LINE__);
        }
        $this->LeavingDate = $leavingDate;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\Consultation_V3
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get Km value
     * @return int
     */
    public function getKm()
    {
        return $this->Km;
    }
    /**
     * Set Km value
     * @param int $km
     * @return \StructType\Consultation_V3
     */
    public function setKm($km = null)
    {
        // validation for constraint: int
        if (!is_null($km) && !is_numeric($km)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($km)), __LINE__);
        }
        $this->Km = $km;
        return $this;
    }
    /**
     * Get ConsultationID value
     * @return int
     */
    public function getConsultationID()
    {
        return $this->ConsultationID;
    }
    /**
     * Set ConsultationID value
     * @param int $consultationID
     * @return \StructType\Consultation_V3
     */
    public function setConsultationID($consultationID = null)
    {
        // validation for constraint: int
        if (!is_null($consultationID) && !is_numeric($consultationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($consultationID)), __LINE__);
        }
        $this->ConsultationID = $consultationID;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\Consultation_V3
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlaceIdentifier|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlaceIdentifier $place
     * @return \StructType\Consultation_V3
     */
    public function setPlace(\StructType\PlaceIdentifier $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\TripIdentifier|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\TripIdentifier $trip
     * @return \StructType\Consultation_V3
     */
    public function setTrip(\StructType\TripIdentifier $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\Consultation_V3
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\Consultation_V3
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\Consultation_V3
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @return \StructType\Consultation_V3
     */
    public function setCoDriver(\StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Consultation_V3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
