<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyIdentifier StructType
 * @subpackage Structs
 */
class CompanyIdentifier extends AbstractStructBase
{
    /**
     * The CompanyIdentifierType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CompanyIdentifierType;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * Constructor method for CompanyIdentifier
     * @uses CompanyIdentifier::setCompanyIdentifierType()
     * @uses CompanyIdentifier::setId()
     * @param string $companyIdentifierType
     * @param string $id
     */
    public function __construct($companyIdentifierType = null, $id = null)
    {
        $this
            ->setCompanyIdentifierType($companyIdentifierType)
            ->setId($id);
    }
    /**
     * Get CompanyIdentifierType value
     * @return string
     */
    public function getCompanyIdentifierType()
    {
        return $this->CompanyIdentifierType;
    }
    /**
     * Set CompanyIdentifierType value
     * @uses \EnumType\EnumCompanyIdentifierType::valueIsValid()
     * @uses \EnumType\EnumCompanyIdentifierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $companyIdentifierType
     * @return \StructType\CompanyIdentifier
     */
    public function setCompanyIdentifierType($companyIdentifierType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCompanyIdentifierType::valueIsValid($companyIdentifierType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $companyIdentifierType, implode(', ', \EnumType\EnumCompanyIdentifierType::getValidValues())), __LINE__);
        }
        $this->CompanyIdentifierType = $companyIdentifierType;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\CompanyIdentifier
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
