<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Code StructType
 * @subpackage Structs
 */
class Code extends AbstractStructBase
{
    /**
     * The ReportCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReportCode;
    /**
     * The IntegratorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntegratorCode;
    /**
     * Constructor method for Code
     * @uses Code::setReportCode()
     * @uses Code::setIntegratorCode()
     * @param string $reportCode
     * @param string $integratorCode
     */
    public function __construct($reportCode = null, $integratorCode = null)
    {
        $this
            ->setReportCode($reportCode)
            ->setIntegratorCode($integratorCode);
    }
    /**
     * Get ReportCode value
     * @return string|null
     */
    public function getReportCode()
    {
        return $this->ReportCode;
    }
    /**
     * Set ReportCode value
     * @param string $reportCode
     * @return \StructType\Code
     */
    public function setReportCode($reportCode = null)
    {
        // validation for constraint: string
        if (!is_null($reportCode) && !is_string($reportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reportCode)), __LINE__);
        }
        $this->ReportCode = $reportCode;
        return $this;
    }
    /**
     * Get IntegratorCode value
     * @return string|null
     */
    public function getIntegratorCode()
    {
        return $this->IntegratorCode;
    }
    /**
     * Set IntegratorCode value
     * @param string $integratorCode
     * @return \StructType\Code
     */
    public function setIntegratorCode($integratorCode = null)
    {
        // validation for constraint: string
        if (!is_null($integratorCode) && !is_string($integratorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($integratorCode)), __LINE__);
        }
        $this->IntegratorCode = $integratorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Code
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
