<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BorderCrossing StructType
 * @subpackage Structs
 */
class BorderCrossing extends AbstractStructBase
{
    /**
     * The KmEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmEnd;
    /**
     * The KmBegin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmBegin;
    /**
     * The DateEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateEnd;
    /**
     * The DateStart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateStart;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Distance;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Duration;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The CountryOld
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $CountryOld;
    /**
     * The CountryNew
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $CountryNew;
    /**
     * The ServiceTimes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfWorkingCodeDuration
     */
    public $ServiceTimes;
    /**
     * The GpsPlace_Begin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GpsPlace_Begin;
    /**
     * The GpsPlace_End
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GpsPlace_End;
    /**
     * The Position_End
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position_End;
    /**
     * The Position_Begin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position_Begin;
    /**
     * Constructor method for BorderCrossing
     * @uses BorderCrossing::setKmEnd()
     * @uses BorderCrossing::setKmBegin()
     * @uses BorderCrossing::setDateEnd()
     * @uses BorderCrossing::setDateStart()
     * @uses BorderCrossing::setDistance()
     * @uses BorderCrossing::setDuration()
     * @uses BorderCrossing::setVehicle()
     * @uses BorderCrossing::setDriver()
     * @uses BorderCrossing::setCountryOld()
     * @uses BorderCrossing::setCountryNew()
     * @uses BorderCrossing::setServiceTimes()
     * @uses BorderCrossing::setGpsPlace_Begin()
     * @uses BorderCrossing::setGpsPlace_End()
     * @uses BorderCrossing::setPosition_End()
     * @uses BorderCrossing::setPosition_Begin()
     * @param int $kmEnd
     * @param int $kmBegin
     * @param string $dateEnd
     * @param string $dateStart
     * @param int $distance
     * @param int $duration
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\Country $countryOld
     * @param \StructType\Country $countryNew
     * @param \ArrayType\ArrayOfWorkingCodeDuration $serviceTimes
     * @param string $gpsPlace_Begin
     * @param string $gpsPlace_End
     * @param \StructType\Position $position_End
     * @param \StructType\Position $position_Begin
     */
    public function __construct($kmEnd = null, $kmBegin = null, $dateEnd = null, $dateStart = null, $distance = null, $duration = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierPerson $driver = null, \StructType\Country $countryOld = null, \StructType\Country $countryNew = null, \ArrayType\ArrayOfWorkingCodeDuration $serviceTimes = null, $gpsPlace_Begin = null, $gpsPlace_End = null, \StructType\Position $position_End = null, \StructType\Position $position_Begin = null)
    {
        $this
            ->setKmEnd($kmEnd)
            ->setKmBegin($kmBegin)
            ->setDateEnd($dateEnd)
            ->setDateStart($dateStart)
            ->setDistance($distance)
            ->setDuration($duration)
            ->setVehicle($vehicle)
            ->setDriver($driver)
            ->setCountryOld($countryOld)
            ->setCountryNew($countryNew)
            ->setServiceTimes($serviceTimes)
            ->setGpsPlace_Begin($gpsPlace_Begin)
            ->setGpsPlace_End($gpsPlace_End)
            ->setPosition_End($position_End)
            ->setPosition_Begin($position_Begin);
    }
    /**
     * Get KmEnd value
     * @return int
     */
    public function getKmEnd()
    {
        return $this->KmEnd;
    }
    /**
     * Set KmEnd value
     * @param int $kmEnd
     * @return \StructType\BorderCrossing
     */
    public function setKmEnd($kmEnd = null)
    {
        // validation for constraint: int
        if (!is_null($kmEnd) && !is_numeric($kmEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmEnd)), __LINE__);
        }
        $this->KmEnd = $kmEnd;
        return $this;
    }
    /**
     * Get KmBegin value
     * @return int
     */
    public function getKmBegin()
    {
        return $this->KmBegin;
    }
    /**
     * Set KmBegin value
     * @param int $kmBegin
     * @return \StructType\BorderCrossing
     */
    public function setKmBegin($kmBegin = null)
    {
        // validation for constraint: int
        if (!is_null($kmBegin) && !is_numeric($kmBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmBegin)), __LINE__);
        }
        $this->KmBegin = $kmBegin;
        return $this;
    }
    /**
     * Get DateEnd value
     * @return string
     */
    public function getDateEnd()
    {
        return $this->DateEnd;
    }
    /**
     * Set DateEnd value
     * @param string $dateEnd
     * @return \StructType\BorderCrossing
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateEnd)), __LINE__);
        }
        $this->DateEnd = $dateEnd;
        return $this;
    }
    /**
     * Get DateStart value
     * @return string
     */
    public function getDateStart()
    {
        return $this->DateStart;
    }
    /**
     * Set DateStart value
     * @param string $dateStart
     * @return \StructType\BorderCrossing
     */
    public function setDateStart($dateStart = null)
    {
        // validation for constraint: string
        if (!is_null($dateStart) && !is_string($dateStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateStart)), __LINE__);
        }
        $this->DateStart = $dateStart;
        return $this;
    }
    /**
     * Get Distance value
     * @return int
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\BorderCrossing
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !is_numeric($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get Duration value
     * @return int
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\BorderCrossing
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\BorderCrossing
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\BorderCrossing
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CountryOld value
     * @return \StructType\Country|null
     */
    public function getCountryOld()
    {
        return $this->CountryOld;
    }
    /**
     * Set CountryOld value
     * @param \StructType\Country $countryOld
     * @return \StructType\BorderCrossing
     */
    public function setCountryOld(\StructType\Country $countryOld = null)
    {
        $this->CountryOld = $countryOld;
        return $this;
    }
    /**
     * Get CountryNew value
     * @return \StructType\Country|null
     */
    public function getCountryNew()
    {
        return $this->CountryNew;
    }
    /**
     * Set CountryNew value
     * @param \StructType\Country $countryNew
     * @return \StructType\BorderCrossing
     */
    public function setCountryNew(\StructType\Country $countryNew = null)
    {
        $this->CountryNew = $countryNew;
        return $this;
    }
    /**
     * Get ServiceTimes value
     * @return \ArrayType\ArrayOfWorkingCodeDuration|null
     */
    public function getServiceTimes()
    {
        return $this->ServiceTimes;
    }
    /**
     * Set ServiceTimes value
     * @param \ArrayType\ArrayOfWorkingCodeDuration $serviceTimes
     * @return \StructType\BorderCrossing
     */
    public function setServiceTimes(\ArrayType\ArrayOfWorkingCodeDuration $serviceTimes = null)
    {
        $this->ServiceTimes = $serviceTimes;
        return $this;
    }
    /**
     * Get GpsPlace_Begin value
     * @return string|null
     */
    public function getGpsPlace_Begin()
    {
        return $this->GpsPlace_Begin;
    }
    /**
     * Set GpsPlace_Begin value
     * @param string $gpsPlace_Begin
     * @return \StructType\BorderCrossing
     */
    public function setGpsPlace_Begin($gpsPlace_Begin = null)
    {
        // validation for constraint: string
        if (!is_null($gpsPlace_Begin) && !is_string($gpsPlace_Begin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gpsPlace_Begin)), __LINE__);
        }
        $this->GpsPlace_Begin = $gpsPlace_Begin;
        return $this;
    }
    /**
     * Get GpsPlace_End value
     * @return string|null
     */
    public function getGpsPlace_End()
    {
        return $this->GpsPlace_End;
    }
    /**
     * Set GpsPlace_End value
     * @param string $gpsPlace_End
     * @return \StructType\BorderCrossing
     */
    public function setGpsPlace_End($gpsPlace_End = null)
    {
        // validation for constraint: string
        if (!is_null($gpsPlace_End) && !is_string($gpsPlace_End)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gpsPlace_End)), __LINE__);
        }
        $this->GpsPlace_End = $gpsPlace_End;
        return $this;
    }
    /**
     * Get Position_End value
     * @return \StructType\Position|null
     */
    public function getPosition_End()
    {
        return $this->Position_End;
    }
    /**
     * Set Position_End value
     * @param \StructType\Position $position_End
     * @return \StructType\BorderCrossing
     */
    public function setPosition_End(\StructType\Position $position_End = null)
    {
        $this->Position_End = $position_End;
        return $this;
    }
    /**
     * Get Position_Begin value
     * @return \StructType\Position|null
     */
    public function getPosition_Begin()
    {
        return $this->Position_Begin;
    }
    /**
     * Set Position_Begin value
     * @param \StructType\Position $position_Begin
     * @return \StructType\BorderCrossing
     */
    public function setPosition_Begin(\StructType\Position $position_Begin = null)
    {
        $this->Position_Begin = $position_Begin;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BorderCrossing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
