<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assign StructType
 * @subpackage Structs
 */
class Assign extends SubcontractedVehicleStrategy
{
    /**
     * The From
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $From;
    /**
     * The Until
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Until;
    /**
     * The VehicleList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicleStrategy
     */
    public $VehicleList;
    /**
     * The CompanyStrategySelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CompanyStrategySelection
     */
    public $CompanyStrategySelection;
    /**
     * Constructor method for Assign
     * @uses Assign::setFrom()
     * @uses Assign::setUntil()
     * @uses Assign::setVehicleList()
     * @uses Assign::setCompanyStrategySelection()
     * @param string $from
     * @param string $until
     * @param \ArrayType\ArrayOfIdentifierVehicleStrategy $vehicleList
     * @param \StructType\CompanyStrategySelection $companyStrategySelection
     */
    public function __construct($from = null, $until = null, \ArrayType\ArrayOfIdentifierVehicleStrategy $vehicleList = null, \StructType\CompanyStrategySelection $companyStrategySelection = null)
    {
        $this
            ->setFrom($from)
            ->setUntil($until)
            ->setVehicleList($vehicleList)
            ->setCompanyStrategySelection($companyStrategySelection);
    }
    /**
     * Get From value
     * @return string
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \StructType\Assign
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get Until value
     * @return string
     */
    public function getUntil()
    {
        return $this->Until;
    }
    /**
     * Set Until value
     * @param string $until
     * @return \StructType\Assign
     */
    public function setUntil($until = null)
    {
        // validation for constraint: string
        if (!is_null($until) && !is_string($until)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($until)), __LINE__);
        }
        $this->Until = $until;
        return $this;
    }
    /**
     * Get VehicleList value
     * @return \ArrayType\ArrayOfIdentifierVehicleStrategy|null
     */
    public function getVehicleList()
    {
        return $this->VehicleList;
    }
    /**
     * Set VehicleList value
     * @param \ArrayType\ArrayOfIdentifierVehicleStrategy $vehicleList
     * @return \StructType\Assign
     */
    public function setVehicleList(\ArrayType\ArrayOfIdentifierVehicleStrategy $vehicleList = null)
    {
        $this->VehicleList = $vehicleList;
        return $this;
    }
    /**
     * Get CompanyStrategySelection value
     * @return \StructType\CompanyStrategySelection|null
     */
    public function getCompanyStrategySelection()
    {
        return $this->CompanyStrategySelection;
    }
    /**
     * Set CompanyStrategySelection value
     * @param \StructType\CompanyStrategySelection $companyStrategySelection
     * @return \StructType\Assign
     */
    public function setCompanyStrategySelection(\StructType\CompanyStrategySelection $companyStrategySelection = null)
    {
        $this->CompanyStrategySelection = $companyStrategySelection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Assign
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
