<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssetGroupItem StructType
 * @subpackage Structs
 */
class AssetGroupItem extends AbstractStructBase
{
    /**
     * The GroupCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupCode;
    /**
     * The GroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupName;
    /**
     * The AssetSubGroupList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAssetSubGroupItem
     */
    public $AssetSubGroupList;
    /**
     * Constructor method for AssetGroupItem
     * @uses AssetGroupItem::setGroupCode()
     * @uses AssetGroupItem::setGroupName()
     * @uses AssetGroupItem::setAssetSubGroupList()
     * @param string $groupCode
     * @param string $groupName
     * @param \ArrayType\ArrayOfAssetSubGroupItem $assetSubGroupList
     */
    public function __construct($groupCode = null, $groupName = null, \ArrayType\ArrayOfAssetSubGroupItem $assetSubGroupList = null)
    {
        $this
            ->setGroupCode($groupCode)
            ->setGroupName($groupName)
            ->setAssetSubGroupList($assetSubGroupList);
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\AssetGroupItem
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get GroupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->GroupName;
    }
    /**
     * Set GroupName value
     * @param string $groupName
     * @return \StructType\AssetGroupItem
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupName)), __LINE__);
        }
        $this->GroupName = $groupName;
        return $this;
    }
    /**
     * Get AssetSubGroupList value
     * @return \ArrayType\ArrayOfAssetSubGroupItem|null
     */
    public function getAssetSubGroupList()
    {
        return $this->AssetSubGroupList;
    }
    /**
     * Set AssetSubGroupList value
     * @param \ArrayType\ArrayOfAssetSubGroupItem $assetSubGroupList
     * @return \StructType\AssetGroupItem
     */
    public function setAssetSubGroupList(\ArrayType\ArrayOfAssetSubGroupItem $assetSubGroupList = null)
    {
        $this->AssetSubGroupList = $assetSubGroupList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AssetGroupItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
