<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Anomaly StructType
 * @subpackage Structs
 */
class Anomaly extends AbstractStructBase
{
    /**
     * The AnomalyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AnomalyID;
    /**
     * The Count
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Count;
    /**
     * The IsDealed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsDealed;
    /**
     * The AnomalyDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AnomalyDateTime;
    /**
     * The AnomalyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnomalyCode;
    /**
     * The AnomalyDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnomalyDescription;
    /**
     * The Dispatcher
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Dispatcher;
    /**
     * The Trip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Trip;
    /**
     * The Place
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Place;
    /**
     * The Job
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Job;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Product;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The AnomalyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnomalyName;
    /**
     * Constructor method for Anomaly
     * @uses Anomaly::setAnomalyID()
     * @uses Anomaly::setCount()
     * @uses Anomaly::setIsDealed()
     * @uses Anomaly::setAnomalyDateTime()
     * @uses Anomaly::setAnomalyCode()
     * @uses Anomaly::setAnomalyDescription()
     * @uses Anomaly::setDispatcher()
     * @uses Anomaly::setTrip()
     * @uses Anomaly::setPlace()
     * @uses Anomaly::setJob()
     * @uses Anomaly::setProduct()
     * @uses Anomaly::setVehicle()
     * @uses Anomaly::setDriver()
     * @uses Anomaly::setAnomalyName()
     * @param int $anomalyID
     * @param int $count
     * @param bool $isDealed
     * @param string $anomalyDateTime
     * @param string $anomalyCode
     * @param string $anomalyDescription
     * @param string $dispatcher
     * @param \StructType\PlanningItem $trip
     * @param \StructType\PlanningItem $place
     * @param \StructType\PlanningItem $job
     * @param \StructType\PlanningItem $product
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierPerson $driver
     * @param string $anomalyName
     */
    public function __construct($anomalyID = null, $count = null, $isDealed = null, $anomalyDateTime = null, $anomalyCode = null, $anomalyDescription = null, $dispatcher = null, \StructType\PlanningItem $trip = null, \StructType\PlanningItem $place = null, \StructType\PlanningItem $job = null, \StructType\PlanningItem $product = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierPerson $driver = null, $anomalyName = null)
    {
        $this
            ->setAnomalyID($anomalyID)
            ->setCount($count)
            ->setIsDealed($isDealed)
            ->setAnomalyDateTime($anomalyDateTime)
            ->setAnomalyCode($anomalyCode)
            ->setAnomalyDescription($anomalyDescription)
            ->setDispatcher($dispatcher)
            ->setTrip($trip)
            ->setPlace($place)
            ->setJob($job)
            ->setProduct($product)
            ->setVehicle($vehicle)
            ->setDriver($driver)
            ->setAnomalyName($anomalyName);
    }
    /**
     * Get AnomalyID value
     * @return int
     */
    public function getAnomalyID()
    {
        return $this->AnomalyID;
    }
    /**
     * Set AnomalyID value
     * @param int $anomalyID
     * @return \StructType\Anomaly
     */
    public function setAnomalyID($anomalyID = null)
    {
        // validation for constraint: int
        if (!is_null($anomalyID) && !is_numeric($anomalyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($anomalyID)), __LINE__);
        }
        $this->AnomalyID = $anomalyID;
        return $this;
    }
    /**
     * Get Count value
     * @return int
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\Anomaly
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get IsDealed value
     * @return bool
     */
    public function getIsDealed()
    {
        return $this->IsDealed;
    }
    /**
     * Set IsDealed value
     * @param bool $isDealed
     * @return \StructType\Anomaly
     */
    public function setIsDealed($isDealed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDealed) && !is_bool($isDealed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDealed)), __LINE__);
        }
        $this->IsDealed = $isDealed;
        return $this;
    }
    /**
     * Get AnomalyDateTime value
     * @return string
     */
    public function getAnomalyDateTime()
    {
        return $this->AnomalyDateTime;
    }
    /**
     * Set AnomalyDateTime value
     * @param string $anomalyDateTime
     * @return \StructType\Anomaly
     */
    public function setAnomalyDateTime($anomalyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($anomalyDateTime) && !is_string($anomalyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($anomalyDateTime)), __LINE__);
        }
        $this->AnomalyDateTime = $anomalyDateTime;
        return $this;
    }
    /**
     * Get AnomalyCode value
     * @return string|null
     */
    public function getAnomalyCode()
    {
        return $this->AnomalyCode;
    }
    /**
     * Set AnomalyCode value
     * @param string $anomalyCode
     * @return \StructType\Anomaly
     */
    public function setAnomalyCode($anomalyCode = null)
    {
        // validation for constraint: string
        if (!is_null($anomalyCode) && !is_string($anomalyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($anomalyCode)), __LINE__);
        }
        $this->AnomalyCode = $anomalyCode;
        return $this;
    }
    /**
     * Get AnomalyDescription value
     * @return string|null
     */
    public function getAnomalyDescription()
    {
        return $this->AnomalyDescription;
    }
    /**
     * Set AnomalyDescription value
     * @param string $anomalyDescription
     * @return \StructType\Anomaly
     */
    public function setAnomalyDescription($anomalyDescription = null)
    {
        // validation for constraint: string
        if (!is_null($anomalyDescription) && !is_string($anomalyDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($anomalyDescription)), __LINE__);
        }
        $this->AnomalyDescription = $anomalyDescription;
        return $this;
    }
    /**
     * Get Dispatcher value
     * @return string|null
     */
    public function getDispatcher()
    {
        return $this->Dispatcher;
    }
    /**
     * Set Dispatcher value
     * @param string $dispatcher
     * @return \StructType\Anomaly
     */
    public function setDispatcher($dispatcher = null)
    {
        // validation for constraint: string
        if (!is_null($dispatcher) && !is_string($dispatcher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dispatcher)), __LINE__);
        }
        $this->Dispatcher = $dispatcher;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\PlanningItem|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\PlanningItem $trip
     * @return \StructType\Anomaly
     */
    public function setTrip(\StructType\PlanningItem $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlanningItem|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlanningItem $place
     * @return \StructType\Anomaly
     */
    public function setPlace(\StructType\PlanningItem $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Job value
     * @return \StructType\PlanningItem|null
     */
    public function getJob()
    {
        return $this->Job;
    }
    /**
     * Set Job value
     * @param \StructType\PlanningItem $job
     * @return \StructType\Anomaly
     */
    public function setJob(\StructType\PlanningItem $job = null)
    {
        $this->Job = $job;
        return $this;
    }
    /**
     * Get Product value
     * @return \StructType\PlanningItem|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \StructType\PlanningItem $product
     * @return \StructType\Anomaly
     */
    public function setProduct(\StructType\PlanningItem $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\Anomaly
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\Anomaly
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get AnomalyName value
     * @return string|null
     */
    public function getAnomalyName()
    {
        return $this->AnomalyName;
    }
    /**
     * Set AnomalyName value
     * @param string $anomalyName
     * @return \StructType\Anomaly
     */
    public function setAnomalyName($anomalyName = null)
    {
        // validation for constraint: string
        if (!is_null($anomalyName) && !is_string($anomalyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($anomalyName)), __LINE__);
        }
        $this->AnomalyName = $anomalyName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Anomaly
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
