<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlarmMessageResult StructType
 * @subpackage Structs
 */
class AlarmMessageResult extends AbstractStructBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The AlarmMessageStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AlarmMessageStatus;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The AlarmMessageType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AlarmMessageType;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The GeoZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeoZoneResult
     */
    public $GeoZone;
    /**
     * Constructor method for AlarmMessageResult
     * @uses AlarmMessageResult::setDate()
     * @uses AlarmMessageResult::setAlarmMessageStatus()
     * @uses AlarmMessageResult::setMessage()
     * @uses AlarmMessageResult::setAlarmMessageType()
     * @uses AlarmMessageResult::setVehicle()
     * @uses AlarmMessageResult::setTrailer()
     * @uses AlarmMessageResult::setDriver()
     * @uses AlarmMessageResult::setPosition()
     * @uses AlarmMessageResult::setGeoZone()
     * @param string $date
     * @param string $alarmMessageStatus
     * @param string $message
     * @param string $alarmMessageType
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\Position $position
     * @param \StructType\GeoZoneResult $geoZone
     */
    public function __construct($date = null, $alarmMessageStatus = null, $message = null, $alarmMessageType = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null, \StructType\IdentifierPerson $driver = null, \StructType\Position $position = null, \StructType\GeoZoneResult $geoZone = null)
    {
        $this
            ->setDate($date)
            ->setAlarmMessageStatus($alarmMessageStatus)
            ->setMessage($message)
            ->setAlarmMessageType($alarmMessageType)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver)
            ->setPosition($position)
            ->setGeoZone($geoZone);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\AlarmMessageResult
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get AlarmMessageStatus value
     * @return string
     */
    public function getAlarmMessageStatus()
    {
        return $this->AlarmMessageStatus;
    }
    /**
     * Set AlarmMessageStatus value
     * @uses \EnumType\EnumAlarmMessageStatus::valueIsValid()
     * @uses \EnumType\EnumAlarmMessageStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alarmMessageStatus
     * @return \StructType\AlarmMessageResult
     */
    public function setAlarmMessageStatus($alarmMessageStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumAlarmMessageStatus::valueIsValid($alarmMessageStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alarmMessageStatus, implode(', ', \EnumType\EnumAlarmMessageStatus::getValidValues())), __LINE__);
        }
        $this->AlarmMessageStatus = $alarmMessageStatus;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\AlarmMessageResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get AlarmMessageType value
     * @return string|null
     */
    public function getAlarmMessageType()
    {
        return $this->AlarmMessageType;
    }
    /**
     * Set AlarmMessageType value
     * @param string $alarmMessageType
     * @return \StructType\AlarmMessageResult
     */
    public function setAlarmMessageType($alarmMessageType = null)
    {
        // validation for constraint: string
        if (!is_null($alarmMessageType) && !is_string($alarmMessageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alarmMessageType)), __LINE__);
        }
        $this->AlarmMessageType = $alarmMessageType;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\AlarmMessageResult
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\AlarmMessageResult
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\AlarmMessageResult
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\AlarmMessageResult
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get GeoZone value
     * @return \StructType\GeoZoneResult|null
     */
    public function getGeoZone()
    {
        return $this->GeoZone;
    }
    /**
     * Set GeoZone value
     * @param \StructType\GeoZoneResult $geoZone
     * @return \StructType\AlarmMessageResult
     */
    public function setGeoZone(\StructType\GeoZoneResult $geoZone = null)
    {
        $this->GeoZone = $geoZone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AlarmMessageResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
