<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityVersionResult_V5 StructType
 * @subpackage Structs
 */
class ActivityVersionResult_V5 extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Version;
    /**
     * The Activities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfActivityInfo_V5
     */
    public $Activities;
    /**
     * Constructor method for ActivityVersionResult_V5
     * @uses ActivityVersionResult_V5::setVersion()
     * @uses ActivityVersionResult_V5::setActivities()
     * @param int $version
     * @param \ArrayType\ArrayOfActivityInfo_V5 $activities
     */
    public function __construct($version = null, \ArrayType\ArrayOfActivityInfo_V5 $activities = null)
    {
        $this
            ->setVersion($version)
            ->setActivities($activities);
    }
    /**
     * Get Version value
     * @return int
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param int $version
     * @return \StructType\ActivityVersionResult_V5
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !is_numeric($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Activities value
     * @return \ArrayType\ArrayOfActivityInfo_V5|null
     */
    public function getActivities()
    {
        return $this->Activities;
    }
    /**
     * Set Activities value
     * @param \ArrayType\ArrayOfActivityInfo_V5 $activities
     * @return \StructType\ActivityVersionResult_V5
     */
    public function setActivities(\ArrayType\ArrayOfActivityInfo_V5 $activities = null)
    {
        $this->Activities = $activities;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActivityVersionResult_V5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
