<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityReportSelection_V2 StructType
 * @subpackage Structs
 */
class ActivityReportSelection_V2 extends AbstractStructBase
{
    /**
     * The ExcludeCodriver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ExcludeCodriver;
    /**
     * The IncludeRemarks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeRemarks;
    /**
     * The IncludeRegistrations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeRegistrations;
    /**
     * The IncludeUnplannedPlanningInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeUnplannedPlanningInfo;
    /**
     * The Drivers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * The Vehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * The Activities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfActivity
     */
    public $Activities;
    /**
     * The DateTimeRangeSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PeriodSelectionWithDateType
     */
    public $DateTimeRangeSelection;
    /**
     * The DateTimeSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeAndIdSelection
     */
    public $DateTimeSelection;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The TripID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripID;
    /**
     * Constructor method for ActivityReportSelection_V2
     * @uses ActivityReportSelection_V2::setExcludeCodriver()
     * @uses ActivityReportSelection_V2::setIncludeRemarks()
     * @uses ActivityReportSelection_V2::setIncludeRegistrations()
     * @uses ActivityReportSelection_V2::setIncludeUnplannedPlanningInfo()
     * @uses ActivityReportSelection_V2::setDrivers()
     * @uses ActivityReportSelection_V2::setVehicles()
     * @uses ActivityReportSelection_V2::setActivities()
     * @uses ActivityReportSelection_V2::setDateTimeRangeSelection()
     * @uses ActivityReportSelection_V2::setDateTimeSelection()
     * @uses ActivityReportSelection_V2::setReference()
     * @uses ActivityReportSelection_V2::setTripID()
     * @param bool $excludeCodriver
     * @param bool $includeRemarks
     * @param bool $includeRegistrations
     * @param bool $includeUnplannedPlanningInfo
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @param \ArrayType\ArrayOfActivity $activities
     * @param \StructType\PeriodSelectionWithDateType $dateTimeRangeSelection
     * @param \StructType\DateTimeAndIdSelection $dateTimeSelection
     * @param string $reference
     * @param string $tripID
     */
    public function __construct($excludeCodriver = null, $includeRemarks = null, $includeRegistrations = null, $includeUnplannedPlanningInfo = null, \ArrayType\ArrayOfIdentifier $drivers = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null, \ArrayType\ArrayOfActivity $activities = null, \StructType\PeriodSelectionWithDateType $dateTimeRangeSelection = null, \StructType\DateTimeAndIdSelection $dateTimeSelection = null, $reference = null, $tripID = null)
    {
        $this
            ->setExcludeCodriver($excludeCodriver)
            ->setIncludeRemarks($includeRemarks)
            ->setIncludeRegistrations($includeRegistrations)
            ->setIncludeUnplannedPlanningInfo($includeUnplannedPlanningInfo)
            ->setDrivers($drivers)
            ->setVehicles($vehicles)
            ->setActivities($activities)
            ->setDateTimeRangeSelection($dateTimeRangeSelection)
            ->setDateTimeSelection($dateTimeSelection)
            ->setReference($reference)
            ->setTripID($tripID);
    }
    /**
     * Get ExcludeCodriver value
     * @return bool
     */
    public function getExcludeCodriver()
    {
        return $this->ExcludeCodriver;
    }
    /**
     * Set ExcludeCodriver value
     * @param bool $excludeCodriver
     * @return \StructType\ActivityReportSelection_V2
     */
    public function setExcludeCodriver($excludeCodriver = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeCodriver) && !is_bool($excludeCodriver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($excludeCodriver)), __LINE__);
        }
        $this->ExcludeCodriver = $excludeCodriver;
        return $this;
    }
    /**
     * Get IncludeRemarks value
     * @return bool
     */
    public function getIncludeRemarks()
    {
        return $this->IncludeRemarks;
    }
    /**
     * Set IncludeRemarks value
     * @param bool $includeRemarks
     * @return \StructType\ActivityReportSelection_V2
     */
    public function setIncludeRemarks($includeRemarks = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeRemarks) && !is_bool($includeRemarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeRemarks)), __LINE__);
        }
        $this->IncludeRemarks = $includeRemarks;
        return $this;
    }
    /**
     * Get IncludeRegistrations value
     * @return bool
     */
    public function getIncludeRegistrations()
    {
        return $this->IncludeRegistrations;
    }
    /**
     * Set IncludeRegistrations value
     * @param bool $includeRegistrations
     * @return \StructType\ActivityReportSelection_V2
     */
    public function setIncludeRegistrations($includeRegistrations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeRegistrations) && !is_bool($includeRegistrations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeRegistrations)), __LINE__);
        }
        $this->IncludeRegistrations = $includeRegistrations;
        return $this;
    }
    /**
     * Get IncludeUnplannedPlanningInfo value
     * @return bool
     */
    public function getIncludeUnplannedPlanningInfo()
    {
        return $this->IncludeUnplannedPlanningInfo;
    }
    /**
     * Set IncludeUnplannedPlanningInfo value
     * @param bool $includeUnplannedPlanningInfo
     * @return \StructType\ActivityReportSelection_V2
     */
    public function setIncludeUnplannedPlanningInfo($includeUnplannedPlanningInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeUnplannedPlanningInfo) && !is_bool($includeUnplannedPlanningInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeUnplannedPlanningInfo)), __LINE__);
        }
        $this->IncludeUnplannedPlanningInfo = $includeUnplannedPlanningInfo;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\ActivityReportSelection_V2
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\ActivityReportSelection_V2
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Activities value
     * @return \ArrayType\ArrayOfActivity|null
     */
    public function getActivities()
    {
        return $this->Activities;
    }
    /**
     * Set Activities value
     * @param \ArrayType\ArrayOfActivity $activities
     * @return \StructType\ActivityReportSelection_V2
     */
    public function setActivities(\ArrayType\ArrayOfActivity $activities = null)
    {
        $this->Activities = $activities;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\PeriodSelectionWithDateType|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\PeriodSelectionWithDateType $dateTimeRangeSelection
     * @return \StructType\ActivityReportSelection_V2
     */
    public function setDateTimeRangeSelection(\StructType\PeriodSelectionWithDateType $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
    /**
     * Get DateTimeSelection value
     * @return \StructType\DateTimeAndIdSelection|null
     */
    public function getDateTimeSelection()
    {
        return $this->DateTimeSelection;
    }
    /**
     * Set DateTimeSelection value
     * @param \StructType\DateTimeAndIdSelection $dateTimeSelection
     * @return \StructType\ActivityReportSelection_V2
     */
    public function setDateTimeSelection(\StructType\DateTimeAndIdSelection $dateTimeSelection = null)
    {
        $this->DateTimeSelection = $dateTimeSelection;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\ActivityReportSelection_V2
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get TripID value
     * @return string|null
     */
    public function getTripID()
    {
        return $this->TripID;
    }
    /**
     * Set TripID value
     * @param string $tripID
     * @return \StructType\ActivityReportSelection_V2
     */
    public function setTripID($tripID = null)
    {
        // validation for constraint: string
        if (!is_null($tripID) && !is_string($tripID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tripID)), __LINE__);
        }
        $this->TripID = $tripID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActivityReportSelection_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
