<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityReportItem StructType
 * @subpackage Structs
 */
class ActivityReportItem extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The KmBegin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmBegin;
    /**
     * The KmEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmEnd;
    /**
     * The Consumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption;
    /**
     * The LoadedStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LoadedStatus;
    /**
     * The SpeedAvg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SpeedAvg;
    /**
     * The WorkingCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $WorkingCode;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Trailer_External
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trailer_External;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The CoDriver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $CoDriver;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityInfo
     */
    public $Activity;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The Place
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlaceIdentifier
     */
    public $Place;
    /**
     * The Trip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TripIdentifier
     */
    public $Trip;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * Constructor method for ActivityReportItem
     * @uses ActivityReportItem::setID()
     * @uses ActivityReportItem::setBeginDate()
     * @uses ActivityReportItem::setEndDate()
     * @uses ActivityReportItem::setKmBegin()
     * @uses ActivityReportItem::setKmEnd()
     * @uses ActivityReportItem::setConsumption()
     * @uses ActivityReportItem::setLoadedStatus()
     * @uses ActivityReportItem::setSpeedAvg()
     * @uses ActivityReportItem::setWorkingCode()
     * @uses ActivityReportItem::setVehicle()
     * @uses ActivityReportItem::setTrailer()
     * @uses ActivityReportItem::setTrailer_External()
     * @uses ActivityReportItem::setDriver()
     * @uses ActivityReportItem::setCoDriver()
     * @uses ActivityReportItem::setActivity()
     * @uses ActivityReportItem::setReference()
     * @uses ActivityReportItem::setPlace()
     * @uses ActivityReportItem::setTrip()
     * @uses ActivityReportItem::setPosition()
     * @param int $iD
     * @param string $beginDate
     * @param string $endDate
     * @param int $kmBegin
     * @param int $kmEnd
     * @param float $consumption
     * @param string $loadedStatus
     * @param float $speedAvg
     * @param \StructType\CodeInfo $workingCode
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param string $trailer_External
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierPerson $coDriver
     * @param \StructType\ActivityInfo $activity
     * @param string $reference
     * @param \StructType\PlaceIdentifier $place
     * @param \StructType\TripIdentifier $trip
     * @param \StructType\PositionResult $position
     */
    public function __construct($iD = null, $beginDate = null, $endDate = null, $kmBegin = null, $kmEnd = null, $consumption = null, $loadedStatus = null, $speedAvg = null, \StructType\CodeInfo $workingCode = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null, $trailer_External = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierPerson $coDriver = null, \StructType\ActivityInfo $activity = null, $reference = null, \StructType\PlaceIdentifier $place = null, \StructType\TripIdentifier $trip = null, \StructType\PositionResult $position = null)
    {
        $this
            ->setID($iD)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setKmBegin($kmBegin)
            ->setKmEnd($kmEnd)
            ->setConsumption($consumption)
            ->setLoadedStatus($loadedStatus)
            ->setSpeedAvg($speedAvg)
            ->setWorkingCode($workingCode)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setTrailer_External($trailer_External)
            ->setDriver($driver)
            ->setCoDriver($coDriver)
            ->setActivity($activity)
            ->setReference($reference)
            ->setPlace($place)
            ->setTrip($trip)
            ->setPosition($position);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\ActivityReportItem
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\ActivityReportItem
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ActivityReportItem
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get KmBegin value
     * @return int
     */
    public function getKmBegin()
    {
        return $this->KmBegin;
    }
    /**
     * Set KmBegin value
     * @param int $kmBegin
     * @return \StructType\ActivityReportItem
     */
    public function setKmBegin($kmBegin = null)
    {
        // validation for constraint: int
        if (!is_null($kmBegin) && !is_numeric($kmBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmBegin)), __LINE__);
        }
        $this->KmBegin = $kmBegin;
        return $this;
    }
    /**
     * Get KmEnd value
     * @return int
     */
    public function getKmEnd()
    {
        return $this->KmEnd;
    }
    /**
     * Set KmEnd value
     * @param int $kmEnd
     * @return \StructType\ActivityReportItem
     */
    public function setKmEnd($kmEnd = null)
    {
        // validation for constraint: int
        if (!is_null($kmEnd) && !is_numeric($kmEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmEnd)), __LINE__);
        }
        $this->KmEnd = $kmEnd;
        return $this;
    }
    /**
     * Get Consumption value
     * @return float
     */
    public function getConsumption()
    {
        return $this->Consumption;
    }
    /**
     * Set Consumption value
     * @param float $consumption
     * @return \StructType\ActivityReportItem
     */
    public function setConsumption($consumption = null)
    {
        $this->Consumption = $consumption;
        return $this;
    }
    /**
     * Get LoadedStatus value
     * @return string
     */
    public function getLoadedStatus()
    {
        return $this->LoadedStatus;
    }
    /**
     * Set LoadedStatus value
     * @uses \EnumType\EnumLoadedStatus::valueIsValid()
     * @uses \EnumType\EnumLoadedStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loadedStatus
     * @return \StructType\ActivityReportItem
     */
    public function setLoadedStatus($loadedStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumLoadedStatus::valueIsValid($loadedStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $loadedStatus, implode(', ', \EnumType\EnumLoadedStatus::getValidValues())), __LINE__);
        }
        $this->LoadedStatus = $loadedStatus;
        return $this;
    }
    /**
     * Get SpeedAvg value
     * @return float
     */
    public function getSpeedAvg()
    {
        return $this->SpeedAvg;
    }
    /**
     * Set SpeedAvg value
     * @param float $speedAvg
     * @return \StructType\ActivityReportItem
     */
    public function setSpeedAvg($speedAvg = null)
    {
        $this->SpeedAvg = $speedAvg;
        return $this;
    }
    /**
     * Get WorkingCode value
     * @return \StructType\CodeInfo|null
     */
    public function getWorkingCode()
    {
        return $this->WorkingCode;
    }
    /**
     * Set WorkingCode value
     * @param \StructType\CodeInfo $workingCode
     * @return \StructType\ActivityReportItem
     */
    public function setWorkingCode(\StructType\CodeInfo $workingCode = null)
    {
        $this->WorkingCode = $workingCode;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\ActivityReportItem
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\ActivityReportItem
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Trailer_External value
     * @return string|null
     */
    public function getTrailer_External()
    {
        return $this->Trailer_External;
    }
    /**
     * Set Trailer_External value
     * @param string $trailer_External
     * @return \StructType\ActivityReportItem
     */
    public function setTrailer_External($trailer_External = null)
    {
        // validation for constraint: string
        if (!is_null($trailer_External) && !is_string($trailer_External)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trailer_External)), __LINE__);
        }
        $this->Trailer_External = $trailer_External;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\ActivityReportItem
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson $coDriver
     * @return \StructType\ActivityReportItem
     */
    public function setCoDriver(\StructType\IdentifierPerson $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\ActivityInfo|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\ActivityInfo $activity
     * @return \StructType\ActivityReportItem
     */
    public function setActivity(\StructType\ActivityInfo $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\ActivityReportItem
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlaceIdentifier|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlaceIdentifier $place
     * @return \StructType\ActivityReportItem
     */
    public function setPlace(\StructType\PlaceIdentifier $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\TripIdentifier|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\TripIdentifier $trip
     * @return \StructType\ActivityReportItem
     */
    public function setTrip(\StructType\TripIdentifier $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\ActivityReportItem
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActivityReportItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
