<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityInfo_V5 StructType
 * @subpackage Structs
 */
class ActivityInfo_V5 extends ActivityInfo
{
    /**
     * The StandardActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StandardActivityId;
    /**
     * The CodeList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCode
     */
    public $CodeList;
    /**
     * Constructor method for ActivityInfo_V5
     * @uses ActivityInfo_V5::setStandardActivityId()
     * @uses ActivityInfo_V5::setCodeList()
     * @param int $standardActivityId
     * @param \ArrayType\ArrayOfCode $codeList
     */
    public function __construct($standardActivityId = null, \ArrayType\ArrayOfCode $codeList = null)
    {
        $this
            ->setStandardActivityId($standardActivityId)
            ->setCodeList($codeList);
    }
    /**
     * Get StandardActivityId value
     * @return int
     */
    public function getStandardActivityId()
    {
        return $this->StandardActivityId;
    }
    /**
     * Set StandardActivityId value
     * @param int $standardActivityId
     * @return \StructType\ActivityInfo_V5
     */
    public function setStandardActivityId($standardActivityId = null)
    {
        // validation for constraint: int
        if (!is_null($standardActivityId) && !is_numeric($standardActivityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($standardActivityId)), __LINE__);
        }
        $this->StandardActivityId = $standardActivityId;
        return $this;
    }
    /**
     * Get CodeList value
     * @return \ArrayType\ArrayOfCode|null
     */
    public function getCodeList()
    {
        return $this->CodeList;
    }
    /**
     * Set CodeList value
     * @param \ArrayType\ArrayOfCode $codeList
     * @return \StructType\ActivityInfo_V5
     */
    public function setCodeList(\ArrayType\ArrayOfCode $codeList = null)
    {
        $this->CodeList = $codeList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActivityInfo_V5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
