<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityInfoFieldSelection StructType
 * @subpackage Structs
 */
class ActivityInfoFieldSelection extends AbstractStructBase
{
    /**
     * The InfoFieldId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InfoFieldId;
    /**
     * The InfoFieldValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InfoFieldValue;
    /**
     * Constructor method for ActivityInfoFieldSelection
     * @uses ActivityInfoFieldSelection::setInfoFieldId()
     * @uses ActivityInfoFieldSelection::setInfoFieldValue()
     * @param int $infoFieldId
     * @param string $infoFieldValue
     */
    public function __construct($infoFieldId = null, $infoFieldValue = null)
    {
        $this
            ->setInfoFieldId($infoFieldId)
            ->setInfoFieldValue($infoFieldValue);
    }
    /**
     * Get InfoFieldId value
     * @return int
     */
    public function getInfoFieldId()
    {
        return $this->InfoFieldId;
    }
    /**
     * Set InfoFieldId value
     * @param int $infoFieldId
     * @return \StructType\ActivityInfoFieldSelection
     */
    public function setInfoFieldId($infoFieldId = null)
    {
        // validation for constraint: int
        if (!is_null($infoFieldId) && !is_numeric($infoFieldId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($infoFieldId)), __LINE__);
        }
        $this->InfoFieldId = $infoFieldId;
        return $this;
    }
    /**
     * Get InfoFieldValue value
     * @return string|null
     */
    public function getInfoFieldValue()
    {
        return $this->InfoFieldValue;
    }
    /**
     * Set InfoFieldValue value
     * @param string $infoFieldValue
     * @return \StructType\ActivityInfoFieldSelection
     */
    public function setInfoFieldValue($infoFieldValue = null)
    {
        // validation for constraint: string
        if (!is_null($infoFieldValue) && !is_string($infoFieldValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoFieldValue)), __LINE__);
        }
        $this->InfoFieldValue = $infoFieldValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActivityInfoFieldSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
