<?php

namespace EnumType;

/**
 * This class stands for VehicleCategory EnumType
 * @subpackage Enumerations
 */
class VehicleCategory
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'GeneralCargo'
     * @return string 'GeneralCargo'
     */
    const VALUE_GENERAL_CARGO = 'GeneralCargo';
    /**
     * Constant for value 'BulkTransport'
     * @return string 'BulkTransport'
     */
    const VALUE_BULK_TRANSPORT = 'BulkTransport';
    /**
     * Constant for value 'VehicleTransport'
     * @return string 'VehicleTransport'
     */
    const VALUE_VEHICLE_TRANSPORT = 'VehicleTransport';
    /**
     * Constant for value 'ContainerTransport'
     * @return string 'ContainerTransport'
     */
    const VALUE_CONTAINER_TRANSPORT = 'ContainerTransport';
    /**
     * Constant for value 'ADRTransport'
     * @return string 'ADRTransport'
     */
    const VALUE_ADRTRANSPORT = 'ADRTransport';
    /**
     * Constant for value 'RefrigeratedTransport'
     * @return string 'RefrigeratedTransport'
     */
    const VALUE_REFRIGERATED_TRANSPORT = 'RefrigeratedTransport';
    /**
     * Constant for value 'WasteTransport'
     * @return string 'WasteTransport'
     */
    const VALUE_WASTE_TRANSPORT = 'WasteTransport';
    /**
     * Constant for value 'ChemicalTransport'
     * @return string 'ChemicalTransport'
     */
    const VALUE_CHEMICAL_TRANSPORT = 'ChemicalTransport';
    /**
     * Constant for value 'FoodTransport'
     * @return string 'FoodTransport'
     */
    const VALUE_FOOD_TRANSPORT = 'FoodTransport';
    /**
     * Constant for value 'Distribution'
     * @return string 'Distribution'
     */
    const VALUE_DISTRIBUTION = 'Distribution';
    /**
     * Constant for value 'TXSmart'
     * @return string 'TXSmart'
     */
    const VALUE_TXSMART = 'TXSmart';
    /**
     * Constant for value 'ExceptionalTransport'
     * @return string 'ExceptionalTransport'
     */
    const VALUE_EXCEPTIONAL_TRANSPORT = 'ExceptionalTransport';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'SiloTransport'
     * @return string 'SiloTransport'
     */
    const VALUE_SILO_TRANSPORT = 'SiloTransport';
    /**
     * Constant for value 'AnimalTransport'
     * @return string 'AnimalTransport'
     */
    const VALUE_ANIMAL_TRANSPORT = 'AnimalTransport';
    /**
     * Constant for value 'AGRTransport'
     * @return string 'AGRTransport'
     */
    const VALUE_AGRTRANSPORT = 'AGRTransport';
    /**
     * Constant for value 'ConcreteMixer'
     * @return string 'ConcreteMixer'
     */
    const VALUE_CONCRETE_MIXER = 'ConcreteMixer';
    /**
     * Constant for value 'RoadTrain'
     * @return string 'RoadTrain'
     */
    const VALUE_ROAD_TRAIN = 'RoadTrain';
    /**
     * Constant for value 'Van'
     * @return string 'Van'
     */
    const VALUE_VAN = 'Van';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_GENERAL_CARGO
     * @uses self::VALUE_BULK_TRANSPORT
     * @uses self::VALUE_VEHICLE_TRANSPORT
     * @uses self::VALUE_CONTAINER_TRANSPORT
     * @uses self::VALUE_ADRTRANSPORT
     * @uses self::VALUE_REFRIGERATED_TRANSPORT
     * @uses self::VALUE_WASTE_TRANSPORT
     * @uses self::VALUE_CHEMICAL_TRANSPORT
     * @uses self::VALUE_FOOD_TRANSPORT
     * @uses self::VALUE_DISTRIBUTION
     * @uses self::VALUE_TXSMART
     * @uses self::VALUE_EXCEPTIONAL_TRANSPORT
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_SILO_TRANSPORT
     * @uses self::VALUE_ANIMAL_TRANSPORT
     * @uses self::VALUE_AGRTRANSPORT
     * @uses self::VALUE_CONCRETE_MIXER
     * @uses self::VALUE_ROAD_TRAIN
     * @uses self::VALUE_VAN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_GENERAL_CARGO,
            self::VALUE_BULK_TRANSPORT,
            self::VALUE_VEHICLE_TRANSPORT,
            self::VALUE_CONTAINER_TRANSPORT,
            self::VALUE_ADRTRANSPORT,
            self::VALUE_REFRIGERATED_TRANSPORT,
            self::VALUE_WASTE_TRANSPORT,
            self::VALUE_CHEMICAL_TRANSPORT,
            self::VALUE_FOOD_TRANSPORT,
            self::VALUE_DISTRIBUTION,
            self::VALUE_TXSMART,
            self::VALUE_EXCEPTIONAL_TRANSPORT,
            self::VALUE_OTHER,
            self::VALUE_SILO_TRANSPORT,
            self::VALUE_ANIMAL_TRANSPORT,
            self::VALUE_AGRTRANSPORT,
            self::VALUE_CONCRETE_MIXER,
            self::VALUE_ROAD_TRAIN,
            self::VALUE_VAN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
