<?php

namespace EnumType;

/**
 * This class stands for PositionDataSource EnumType
 * @subpackage Enumerations
 */
class PositionDataSource
{
    /**
     * Constant for value 'OBC'
     * @return string 'OBC'
     */
    const VALUE_OBC = 'OBC';
    /**
     * Constant for value 'Tracer'
     * @return string 'Tracer'
     */
    const VALUE_TRACER = 'Tracer';
    /**
     * Constant for value 'Both'
     * @return string 'Both'
     */
    const VALUE_BOTH = 'Both';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OBC
     * @uses self::VALUE_TRACER
     * @uses self::VALUE_BOTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OBC,
            self::VALUE_TRACER,
            self::VALUE_BOTH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
