<?php

namespace EnumType;

/**
 * This class stands for ObcType EnumType
 * @subpackage Enumerations
 */
class ObcType
{
    /**
     * Constant for value 'Laura'
     * @return string 'Laura'
     */
    const VALUE_LAURA = 'Laura';
    /**
     * Constant for value 'Quattro'
     * @return string 'Quattro'
     */
    const VALUE_QUATTRO = 'Quattro';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'TXMax'
     * @return string 'TXMax'
     */
    const VALUE_TXMAX = 'TXMax';
    /**
     * Constant for value 'TXSmart'
     * @return string 'TXSmart'
     */
    const VALUE_TXSMART = 'TXSmart';
    /**
     * Constant for value 'TXSky'
     * @return string 'TXSky'
     */
    const VALUE_TXSKY = 'TXSky';
    /**
     * Constant for value 'MDT'
     * @return string 'MDT'
     */
    const VALUE_MDT = 'MDT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LAURA
     * @uses self::VALUE_QUATTRO
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_TXMAX
     * @uses self::VALUE_TXSMART
     * @uses self::VALUE_TXSKY
     * @uses self::VALUE_MDT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LAURA,
            self::VALUE_QUATTRO,
            self::VALUE_OTHER,
            self::VALUE_TXMAX,
            self::VALUE_TXSMART,
            self::VALUE_TXSKY,
            self::VALUE_MDT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
