<?php

namespace EnumType;

/**
 * This class stands for GroupTypeV2 EnumType
 * @subpackage Enumerations
 */
class GroupTypeV2
{
    /**
     * Constant for value 'VEHICLES'
     * @return string 'VEHICLES'
     */
    const VALUE_VEHICLES = 'VEHICLES';
    /**
     * Constant for value 'DRIVERS'
     * @return string 'DRIVERS'
     */
    const VALUE_DRIVERS = 'DRIVERS';
    /**
     * Constant for value 'TRAILERS'
     * @return string 'TRAILERS'
     */
    const VALUE_TRAILERS = 'TRAILERS';
    /**
     * Constant for value 'POIS'
     * @return string 'POIS'
     */
    const VALUE_POIS = 'POIS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VEHICLES
     * @uses self::VALUE_DRIVERS
     * @uses self::VALUE_TRAILERS
     * @uses self::VALUE_POIS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VEHICLES,
            self::VALUE_DRIVERS,
            self::VALUE_TRAILERS,
            self::VALUE_POIS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
