<?php

namespace EnumType;

/**
 * This class stands for enumTransferStatus EnumType
 * @subpackage Enumerations
 */
class EnumTransferStatus
{
    /**
     * Constant for value 'NOTHING_DONE_YET'
     * @return string 'NOTHING_DONE_YET'
     */
    const VALUE_NOTHING_DONE_YET = 'NOTHING_DONE_YET';
    /**
     * Constant for value 'BUSY'
     * @return string 'BUSY'
     */
    const VALUE_BUSY = 'BUSY';
    /**
     * Constant for value 'SENT'
     * @return string 'SENT'
     */
    const VALUE_SENT = 'SENT';
    /**
     * Constant for value 'DELIVERED'
     * @return string 'DELIVERED'
     */
    const VALUE_DELIVERED = 'DELIVERED';
    /**
     * Constant for value 'CANCELLED'
     * @return string 'CANCELLED'
     */
    const VALUE_CANCELLED = 'CANCELLED';
    /**
     * Constant for value 'CONFIRMED'
     * @return string 'CONFIRMED'
     */
    const VALUE_CONFIRMED = 'CONFIRMED';
    /**
     * Constant for value 'FINISHED'
     * @return string 'FINISHED'
     */
    const VALUE_FINISHED = 'FINISHED';
    /**
     * Constant for value 'ERROR'
     * @return string 'ERROR'
     */
    const VALUE_ERROR = 'ERROR';
    /**
     * Constant for value 'CREATED_BY_DRIVER'
     * @return string 'CREATED_BY_DRIVER'
     */
    const VALUE_CREATED_BY_DRIVER = 'CREATED_BY_DRIVER';
    /**
     * Constant for value 'COMM_ERROR'
     * @return string 'COMM_ERROR'
     */
    const VALUE_COMM_ERROR = 'COMM_ERROR';
    /**
     * Constant for value 'VIA_TRIP'
     * @return string 'VIA_TRIP'
     */
    const VALUE_VIA_TRIP = 'VIA_TRIP';
    /**
     * Constant for value 'READ_PLANNING'
     * @return string 'READ_PLANNING'
     */
    const VALUE_READ_PLANNING = 'READ_PLANNING';
    /**
     * Constant for value 'PLANNING_STARTED'
     * @return string 'PLANNING_STARTED'
     */
    const VALUE_PLANNING_STARTED = 'PLANNING_STARTED';
    /**
     * Constant for value 'NOT_SUPPORTED_BY_OBC'
     * @return string 'NOT_SUPPORTED_BY_OBC'
     */
    const VALUE_NOT_SUPPORTED_BY_OBC = 'NOT_SUPPORTED_BY_OBC';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOTHING_DONE_YET
     * @uses self::VALUE_BUSY
     * @uses self::VALUE_SENT
     * @uses self::VALUE_DELIVERED
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_CONFIRMED
     * @uses self::VALUE_FINISHED
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_CREATED_BY_DRIVER
     * @uses self::VALUE_COMM_ERROR
     * @uses self::VALUE_VIA_TRIP
     * @uses self::VALUE_READ_PLANNING
     * @uses self::VALUE_PLANNING_STARTED
     * @uses self::VALUE_NOT_SUPPORTED_BY_OBC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOTHING_DONE_YET,
            self::VALUE_BUSY,
            self::VALUE_SENT,
            self::VALUE_DELIVERED,
            self::VALUE_CANCELLED,
            self::VALUE_CONFIRMED,
            self::VALUE_FINISHED,
            self::VALUE_ERROR,
            self::VALUE_CREATED_BY_DRIVER,
            self::VALUE_COMM_ERROR,
            self::VALUE_VIA_TRIP,
            self::VALUE_READ_PLANNING,
            self::VALUE_PLANNING_STARTED,
            self::VALUE_NOT_SUPPORTED_BY_OBC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
