<?php

namespace EnumType;

/**
 * This class stands for enumTransferDirection EnumType
 * @subpackage Enumerations
 */
class EnumTransferDirection
{
    /**
     * Constant for value 'OUTGOING'
     * @return string 'OUTGOING'
     */
    const VALUE_OUTGOING = 'OUTGOING';
    /**
     * Constant for value 'INCOMMING'
     * @return string 'INCOMMING'
     */
    const VALUE_INCOMMING = 'INCOMMING';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OUTGOING
     * @uses self::VALUE_INCOMMING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OUTGOING,
            self::VALUE_INCOMMING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
