<?php

namespace EnumType;

/**
 * This class stands for enumSummaryLevel EnumType
 * @subpackage Enumerations
 */
class EnumSummaryLevel
{
    /**
     * Constant for value 'DAY'
     * @return string 'DAY'
     */
    const VALUE_DAY = 'DAY';
    /**
     * Constant for value 'WEEK'
     * @return string 'WEEK'
     */
    const VALUE_WEEK = 'WEEK';
    /**
     * Constant for value 'MONTH'
     * @return string 'MONTH'
     */
    const VALUE_MONTH = 'MONTH';
    /**
     * Constant for value 'ALL'
     * @return string 'ALL'
     */
    const VALUE_ALL = 'ALL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DAY
     * @uses self::VALUE_WEEK
     * @uses self::VALUE_MONTH
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DAY,
            self::VALUE_WEEK,
            self::VALUE_MONTH,
            self::VALUE_ALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
