<?php

namespace EnumType;

/**
 * This class stands for enumSource EnumType
 * @subpackage Enumerations
 */
class EnumSource
{
    /**
     * Constant for value 'MESSAGE'
     * @return string 'MESSAGE'
     */
    const VALUE_MESSAGE = 'MESSAGE';
    /**
     * Constant for value 'FILE'
     * @return string 'FILE'
     */
    const VALUE_FILE = 'FILE';
    /**
     * Constant for value 'USER'
     * @return string 'USER'
     */
    const VALUE_USER = 'USER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MESSAGE
     * @uses self::VALUE_FILE
     * @uses self::VALUE_USER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MESSAGE,
            self::VALUE_FILE,
            self::VALUE_USER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
