<?php

namespace EnumType;

/**
 * This class stands for enumSelectionType EnumType
 * @subpackage Enumerations
 */
class EnumSelectionType
{
    /**
     * Constant for value 'DETAILS'
     * @return string 'DETAILS'
     */
    const VALUE_DETAILS = 'DETAILS';
    /**
     * Constant for value 'SUMMARY'
     * @return string 'SUMMARY'
     */
    const VALUE_SUMMARY = 'SUMMARY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DETAILS
     * @uses self::VALUE_SUMMARY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DETAILS,
            self::VALUE_SUMMARY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
