<?php

namespace EnumType;

/**
 * This class stands for enumPlanningSelectionModificationsType_V2 EnumType
 * @subpackage Enumerations
 */
class EnumPlanningSelectionModificationsType_V2
{
    /**
     * Constant for value 'TRIP'
     * @return string 'TRIP'
     */
    const VALUE_TRIP = 'TRIP';
    /**
     * Constant for value 'PLACE'
     * @return string 'PLACE'
     */
    const VALUE_PLACE = 'PLACE';
    /**
     * Constant for value 'JOB'
     * @return string 'JOB'
     */
    const VALUE_JOB = 'JOB';
    /**
     * Constant for value 'PRODUCT'
     * @return string 'PRODUCT'
     */
    const VALUE_PRODUCT = 'PRODUCT';
    /**
     * Constant for value 'PLACE_COMMENT'
     * @return string 'PLACE_COMMENT'
     */
    const VALUE_PLACE_COMMENT = 'PLACE_COMMENT';
    /**
     * Constant for value 'ANOMALY'
     * @return string 'ANOMALY'
     */
    const VALUE_ANOMALY = 'ANOMALY';
    /**
     * Constant for value 'CONSULTATION'
     * @return string 'CONSULTATION'
     */
    const VALUE_CONSULTATION = 'CONSULTATION';
    /**
     * Constant for value 'PALLET'
     * @return string 'PALLET'
     */
    const VALUE_PALLET = 'PALLET';
    /**
     * Constant for value 'EXTRA_INFO'
     * @return string 'EXTRA_INFO'
     */
    const VALUE_EXTRA_INFO = 'EXTRA_INFO';
    /**
     * Constant for value 'SCANNED_DOCUMENT'
     * @return string 'SCANNED_DOCUMENT'
     */
    const VALUE_SCANNED_DOCUMENT = 'SCANNED_DOCUMENT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRIP
     * @uses self::VALUE_PLACE
     * @uses self::VALUE_JOB
     * @uses self::VALUE_PRODUCT
     * @uses self::VALUE_PLACE_COMMENT
     * @uses self::VALUE_ANOMALY
     * @uses self::VALUE_CONSULTATION
     * @uses self::VALUE_PALLET
     * @uses self::VALUE_EXTRA_INFO
     * @uses self::VALUE_SCANNED_DOCUMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRIP,
            self::VALUE_PLACE,
            self::VALUE_JOB,
            self::VALUE_PRODUCT,
            self::VALUE_PLACE_COMMENT,
            self::VALUE_ANOMALY,
            self::VALUE_CONSULTATION,
            self::VALUE_PALLET,
            self::VALUE_EXTRA_INFO,
            self::VALUE_SCANNED_DOCUMENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
