<?php

namespace EnumType;

/**
 * This class stands for enumPlanningItemSelectionType EnumType
 * @subpackage Enumerations
 */
class EnumPlanningItemSelectionType
{
    /**
     * Constant for value 'TRIP'
     * @return string 'TRIP'
     */
    const VALUE_TRIP = 'TRIP';
    /**
     * Constant for value 'PLACE'
     * @return string 'PLACE'
     */
    const VALUE_PLACE = 'PLACE';
    /**
     * Constant for value 'JOB'
     * @return string 'JOB'
     */
    const VALUE_JOB = 'JOB';
    /**
     * Constant for value 'PRODUCT'
     * @return string 'PRODUCT'
     */
    const VALUE_PRODUCT = 'PRODUCT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRIP
     * @uses self::VALUE_PLACE
     * @uses self::VALUE_JOB
     * @uses self::VALUE_PRODUCT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRIP,
            self::VALUE_PLACE,
            self::VALUE_JOB,
            self::VALUE_PRODUCT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
