<?php

namespace EnumType;

/**
 * This class stands for enumMagellanTracerIdentifierType EnumType
 * @subpackage Enumerations
 */
class EnumMagellanTracerIdentifierType
{
    /**
     * Constant for value 'DEVICE_ID'
     * @return string 'DEVICE_ID'
     */
    const VALUE_DEVICE_ID = 'DEVICE_ID';
    /**
     * Constant for value 'NAME'
     * @return string 'NAME'
     */
    const VALUE_NAME = 'NAME';
    /**
     * Constant for value 'CODE'
     * @return string 'CODE'
     */
    const VALUE_CODE = 'CODE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEVICE_ID
     * @uses self::VALUE_NAME
     * @uses self::VALUE_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEVICE_ID,
            self::VALUE_NAME,
            self::VALUE_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
