<?php

namespace EnumType;

/**
 * This class stands for enumLoadedStatus EnumType
 * @subpackage Enumerations
 */
class EnumLoadedStatus
{
    /**
     * Constant for value 'NO_INFO'
     * @return string 'NO_INFO'
     */
    const VALUE_NO_INFO = 'NO_INFO';
    /**
     * Constant for value 'EMPTY'
     * @return string 'EMPTY'
     */
    const VALUE_EMPTY = 'EMPTY';
    /**
     * Constant for value 'LOADED'
     * @return string 'LOADED'
     */
    const VALUE_LOADED = 'LOADED';
    /**
     * Constant for value 'SOLO'
     * @return string 'SOLO'
     */
    const VALUE_SOLO = 'SOLO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_INFO
     * @uses self::VALUE_EMPTY
     * @uses self::VALUE_LOADED
     * @uses self::VALUE_SOLO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_INFO,
            self::VALUE_EMPTY,
            self::VALUE_LOADED,
            self::VALUE_SOLO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
