<?php

namespace EnumType;

/**
 * This class stands for enumIdentifierPlace EnumType
 * @subpackage Enumerations
 */
class EnumIdentifierPlace
{
    /**
     * Constant for value 'PLACE_ID'
     * @return string 'PLACE_ID'
     */
    const VALUE_PLACE_ID = 'PLACE_ID';
    /**
     * Constant for value 'TRANSICS_ID'
     * @return string 'TRANSICS_ID'
     */
    const VALUE_TRANSICS_ID = 'TRANSICS_ID';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PLACE_ID
     * @uses self::VALUE_TRANSICS_ID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PLACE_ID,
            self::VALUE_TRANSICS_ID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
