<?php

namespace EnumType;

/**
 * This class stands for enumGeoZoneUpdateType EnumType
 * @subpackage Enumerations
 */
class EnumGeoZoneUpdateType
{
    /**
     * Constant for value 'ADD_GEOZONES'
     * @return string 'ADD_GEOZONES'
     */
    const VALUE_ADD_GEOZONES = 'ADD_GEOZONES';
    /**
     * Constant for value 'REMOVE_GEOZONES_BEFORE_UPDATE'
     * @return string 'REMOVE_GEOZONES_BEFORE_UPDATE'
     */
    const VALUE_REMOVE_GEOZONES_BEFORE_UPDATE = 'REMOVE_GEOZONES_BEFORE_UPDATE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADD_GEOZONES
     * @uses self::VALUE_REMOVE_GEOZONES_BEFORE_UPDATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADD_GEOZONES,
            self::VALUE_REMOVE_GEOZONES_BEFORE_UPDATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
