<?php

namespace EnumType;

/**
 * This class stands for enumGeoFencingEventType EnumType
 * @subpackage Enumerations
 */
class EnumGeoFencingEventType
{
    /**
     * Constant for value 'ENTERING_ZONE'
     * @return string 'ENTERING_ZONE'
     */
    const VALUE_ENTERING_ZONE = 'ENTERING_ZONE';
    /**
     * Constant for value 'LEAVING_ZONE'
     * @return string 'LEAVING_ZONE'
     */
    const VALUE_LEAVING_ZONE = 'LEAVING_ZONE';
    /**
     * Constant for value 'RESTRICTED_ZONE'
     * @return string 'RESTRICTED_ZONE'
     */
    const VALUE_RESTRICTED_ZONE = 'RESTRICTED_ZONE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENTERING_ZONE
     * @uses self::VALUE_LEAVING_ZONE
     * @uses self::VALUE_RESTRICTED_ZONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENTERING_ZONE,
            self::VALUE_LEAVING_ZONE,
            self::VALUE_RESTRICTED_ZONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
