<?php

namespace EnumType;

/**
 * This class stands for enumGeoFenceTransferStatus EnumType
 * @subpackage Enumerations
 */
class EnumGeoFenceTransferStatus
{
    /**
     * Constant for value 'SENDING'
     * @return string 'SENDING'
     */
    const VALUE_SENDING = 'SENDING';
    /**
     * Constant for value 'ERROR'
     * @return string 'ERROR'
     */
    const VALUE_ERROR = 'ERROR';
    /**
     * Constant for value 'DELIVERED'
     * @return string 'DELIVERED'
     */
    const VALUE_DELIVERED = 'DELIVERED';
    /**
     * Constant for value 'SENDING_DELETION'
     * @return string 'SENDING_DELETION'
     */
    const VALUE_SENDING_DELETION = 'SENDING_DELETION';
    /**
     * Constant for value 'ERROR_DELETION'
     * @return string 'ERROR_DELETION'
     */
    const VALUE_ERROR_DELETION = 'ERROR_DELETION';
    /**
     * Constant for value 'DELETED'
     * @return string 'DELETED'
     */
    const VALUE_DELETED = 'DELETED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SENDING
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_DELIVERED
     * @uses self::VALUE_SENDING_DELETION
     * @uses self::VALUE_ERROR_DELETION
     * @uses self::VALUE_DELETED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SENDING,
            self::VALUE_ERROR,
            self::VALUE_DELIVERED,
            self::VALUE_SENDING_DELETION,
            self::VALUE_ERROR_DELETION,
            self::VALUE_DELETED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
