<?php

namespace EnumType;

/**
 * This class stands for enumGeoFenceIdentifierType EnumType
 * @subpackage Enumerations
 */
class EnumGeoFenceIdentifierType
{
    /**
     * Constant for value 'TRANSICS_ID'
     * @return string 'TRANSICS_ID'
     */
    const VALUE_TRANSICS_ID = 'TRANSICS_ID';
    /**
     * Constant for value 'NAME'
     * @return string 'NAME'
     */
    const VALUE_NAME = 'NAME';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRANSICS_ID
     * @uses self::VALUE_NAME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRANSICS_ID,
            self::VALUE_NAME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
