<?php

namespace EnumType;

/**
 * This class stands for enumGeoFenceDirection EnumType
 * @subpackage Enumerations
 */
class EnumGeoFenceDirection
{
    /**
     * Constant for value 'ENTER'
     * @return string 'ENTER'
     */
    const VALUE_ENTER = 'ENTER';
    /**
     * Constant for value 'LEAVE'
     * @return string 'LEAVE'
     */
    const VALUE_LEAVE = 'LEAVE';
    /**
     * Constant for value 'ENTER_LEAVE'
     * @return string 'ENTER_LEAVE'
     */
    const VALUE_ENTER_LEAVE = 'ENTER_LEAVE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENTER
     * @uses self::VALUE_LEAVE
     * @uses self::VALUE_ENTER_LEAVE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENTER,
            self::VALUE_LEAVE,
            self::VALUE_ENTER_LEAVE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
