<?php

namespace EnumType;

/**
 * This class stands for enumDeviceType EnumType
 * @subpackage Enumerations
 */
class EnumDeviceType
{
    /**
     * Constant for value 'LAURA'
     * @return string 'LAURA'
     */
    const VALUE_LAURA = 'LAURA';
    /**
     * Constant for value 'QUATTRO'
     * @return string 'QUATTRO'
     */
    const VALUE_QUATTRO = 'QUATTRO';
    /**
     * Constant for value 'OTHER'
     * @return string 'OTHER'
     */
    const VALUE_OTHER = 'OTHER';
    /**
     * Constant for value 'TX_MAX'
     * @return string 'TX_MAX'
     */
    const VALUE_TX_MAX = 'TX_MAX';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LAURA
     * @uses self::VALUE_QUATTRO
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_TX_MAX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LAURA,
            self::VALUE_QUATTRO,
            self::VALUE_OTHER,
            self::VALUE_TX_MAX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
