<?php

namespace EnumType;

/**
 * This class stands for enumDateTypeSelection EnumType
 * @subpackage Enumerations
 */
class EnumDateTypeSelection
{
    /**
     * Constant for value 'STARTED'
     * @return string 'STARTED'
     */
    const VALUE_STARTED = 'STARTED';
    /**
     * Constant for value 'MODIFIED'
     * @return string 'MODIFIED'
     */
    const VALUE_MODIFIED = 'MODIFIED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STARTED
     * @uses self::VALUE_MODIFIED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STARTED,
            self::VALUE_MODIFIED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
